BEM.DOM.decl({ block: 'b-phrase-popup', modName: 'page', modVal: 'campaign' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            BEM.blocks['i-utils'].graspSelf.call(this, {
                _tumbler: 'tumbler on tumbler',
                _cancelBtn: 'button on cancel-button',
                _okBtn: 'button on ok-button',
                _delBtn: '? button on delete-button',
                _adjustBtn: '? button on adjust-button'
            });

            this._subscriptionManager = BEM.create('i-subscription-manager');
            this._subscriptionManager
                .on(this._tumbler, 'change', this._onTumblerChange, this)
                .on(this._cancelBtn, 'click', this._cancel, this)
                .on(this._okBtn, 'click', this._savePhrase, this);

            this._delBtn && this._subscriptionManager.on(this._delBtn, 'click', this._deletePhrase, this);
            this._adjustBtn && this._subscriptionManager.on(this._adjustBtn, 'click', this._adjustPhrase, this);
        },

        adjusted: function(modName, modVal) {
            if (!this._adjustBlock) return;
            this._adjustBlock[modVal == 'yes' ? 'attach' : 'detach'](this);
        }
    },

    /**
     * Инициализация блока
     * @param {Object} params - данные о родителе
     * @returns {BEM}
     */
    init: function(params) {
        var type = this.getMod('type');

        this.__base(params);

        this.setMod('state', this.phraseModel.get('state').replace('_', '-'));

        switch (type) {
            case 'interest':
                this.elem('view').html(this.phraseModel.get('interest_name_escape'));
                break;
            case 'retargeting':
                this.elem('view').html('"' + this.phraseModel.get('condition_name_escape') + '"' + ' (' + iget2('b-phrase-popup', 'uslovie-podbora-auditorii', 'условие подбора аудитории') + ')');
                break;
            case 'phrase':
                this._getTmpModel().update(this.phraseModel.toJSON()).fix();
                this._input.val(this.phraseModel.get('phrase'));
                break;
            case 'relevance-match':
                this._input.val('');
                this._input.setMod('hidden', 'yes');
        }

        this._tumbler
            .setMod('checked', this.phraseModel.get('is_suspended') ? '' : 'yes')
            .setMod('focused', '');

        this.listModel = BEM.MODEL.getOrCreate({ name: 'm-phrases-list', id: this.bannersGroupModel.get('modelId') });

        //heliarian - если нет helper - то и campModel только что создано в __base
        if (!this.helper) {
            this.campModel.on('platform', 'change', this._cancel, this);
            this.helper = BEM.blocks['i-phrases-prices-helper'].getInstance('phrases', this.campModel);
        }

        this._input.on('change', function(e) {
            this._okBtn.setMod('disabled', e.block.isLimitExceeded() ? 'yes' : '');
        }, this);

        return this.setMod('adjusted', 'no');
    },

    /**
     * Событие, что временная (несохраненная) фраза изменена
     * @private
     */
    _onTmpPhraseChanged: function() {
        var tmpModel = this._getTmpModel();

        this._input.val(tmpModel.get('phrase'));
        this.elem('view').text(tmpModel.get('phrase'));
    },

    /**
     * Событие переключения тумблера
     * @param {Event} e
     * @param {Object} data
     * @private
     */
    _onTumblerChange: function(e, data) {
        var notChecked = !data.checked,
            isMcbanner = this.bannersGroupModel.name == 'dm-mcbanner-group',
            type = this.getMod('type'),
            tmpModel = this._getTmpModel();

        if (notChecked == tmpModel.get('is_suspended')) return;

        //пытаемся отключить последнюю активную фразу
        if (notChecked && this.bannersGroupModel.isLastActive(this.phraseModel)) {
            this.afterCurrentEvent(function() {
                this._tumbler.setMod('checked', 'yes');
            }, this);

            this._showError({
                phrase: isMcbanner ?
                    iget2('b-phrase-popup', 'nelzya-otklyuchit-poslednyuyu-frazu', 'Нельзя отключить последнюю фразу в группе') :
                    iget2('b-phrase-popup', 'nelzya-otklyuchit-poslednyuyu-frazu-101', 'Нельзя отключить последнюю фразу в объявлении'),
                retargeting: iget2(
                    'b-phrase-popup',
                    'nelzya-otklyuchit-poslednee-uslovie',
                    'Нельзя отключить последнее условие подбора аудитории в объявлении'
                ),
                interest: iget2('b-phrase-popup', 'nelzya-otklyuchit-poslednee-uslovie-102', 'Нельзя отключить последнее условие показа в объявлении'),
                'relevance-match': iget2(
                    'b-phrase-popup',
                    'nelzya-otklyuchit-avtotargeting-pri',
                    'Нельзя отключить автотаргетинг при отсутствии других условий показа'
                )
            }[type]);
        } else {
            tmpModel.update({
                is_suspended: notChecked
            }, this);
        }
    },

    /**
     * Удаление фразы
     * @returns {BEM}
     * @private
     */
    _deletePhrase: function() {
        var type = this.getMod('type');

        BEM.blocks['b-metrika2'].params({
            params: {
                showCamp: {
                    'edit-phrase': 'delete'
                }
            }
        });

        if (!this.bannersGroupModel.isLastActive(this.phraseModel)) {
            this.phraseModel.set('is_deleted', 1, this);
            this._hide();
        } else {
            this._showError({
                phrase: iget2('b-phrase-popup', 'nelzya-udalit-poslednyuyu-frazu', 'Нельзя удалить последнюю фразу в группе'),
                retargeting: iget2('b-phrase-popup', 'nelzya-udalit-poslednee-uslovie', 'Нельзя удалить последнее условие подбора аудитории в группе'),
                interest: iget2('b-phrase-popup', 'nelzya-udalit-poslednee-uslovie-103', 'Нельзя удалить последнее условие показа в группе'),
                'relevance-match': iget2('b-phrase-popup', 'nelzya-udalit-avtotargeting-pri', 'Нельзя удалить автотаргетинг при отсутствии других условий показа')
            }[type]);
        }

        return this;
    },

    /**
     * Открывает панель уточнения фраз
     * @returns {BEM}
     * @private
     */
    _adjustPhrase: function() {
        this._initAdjustBlock();
        this.toggleMod('adjusted', 'yes', 'no');

        BEM.blocks['b-metrika2'].params({
            params: {
                showCamp: {
                    'edit-phrase': 'adjust'
                }
            }
        });

        return this;
    },

    /**
     * Сохранение фразы
     * @returns {BEM}
     * @private
     */
    _savePhrase: function() {
        var type = this.getMod('type'),
            tmpModel = this._getTmpModel(),
            data = this.helper.getModelData(tmpModel, type);

        if (this.phraseModel.get('is_suspended') !== data.is_suspended) {

            BEM.blocks['b-metrika2'].params({
                params: {
                    showCamp: {
                        'edit-phrase': data.is_suspended ? 'suspend' : 'resume'
                    }
                }
            });
        }

        if (this.getMod('type') === 'phrase' && tmpModel.isEmpty('key_words')) {
            if (!tmpModel.isEmpty('minus_words')) {
                this._showError(iget2('b-phrase-popup', 'nelzya-ispolzovat-v-kachestve', 'Нельзя использовать в качестве ключевых фраз только минус-слова'));
                return this;
            } else {
                //если затерли всю фразу - то просто удаляем ее
                this._deletePhrase();
                return;
            }
        } else {
            this._hide();
            this.phraseModel.update(data);
        }

        return this;
    },

    /**
     * Инициализация блока уточнения фраз
     * @returns {BEM}
     * @private
     */
    _initAdjustBlock: function() {
        !this._adjustBlock && (this._adjustBlock = $(BEMHTML.apply({
            block: 'b-phrase-adjustment'
        })).appendTo(this.elem('adjust-block')).bem('b-phrase-adjustment'));

        if (this.bannersGroupModel.getCampaignModel().get('mediaType') == 'mcbanner') {
            this._adjustBlock.setMinusWordsHint(
                iget2(
                    'b-phrase-popup',
                    'dobavlenie-minus-slova-k-104',
                    'Добавление минус-слова к фразе исключает показ баннера по всем запросам, содержащим это слово.'
                ));
        }

        return this._adjustBlock;
    }
}, {

});
