BEM.DOM.decl({ block: 'b-phrase-popup', modName: 'page', modVal: 'multiedit' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            BEM.blocks['i-utils'].graspSelf.call(this, {
                _adjustBlock: 'b-phrase-adjustment inside',
                _closeBtn: 'button on close'
            });

            this._closeBtn.on('click', this._savePhrase, this);
        }
    },

    /**
     * Инициализируем попап
     * @param {BEM} params - данные о родителе
     * @returns {BEM}
     */
    init: function(params) {
        if (this.phraseModel) {
            this.phraseModel.un('phrase', 'change');
        }

        this.phraseModel = params.phraseModel;
        this.parentDomElem = params.parentDomElem;
        this.bannersGroupModel = params.bannersGroupModel;

        this._getTmpModel()
            .update(this.phraseModel.toJSON())
            .fix();

        this._input.val(this.phraseModel.get('phrase'));

        // 13 - паддинг попапа на который необходимо увеличить инпут для вызуального совпадения с родительским блоком,
        // прописан в .b-phrase-popup_page_multiedit
        this.domElem.css('width', this.parentDomElem.width() + 13 + 'px');
        this._adjustBlock.attach(this);

        if (this.bannersGroupModel.getCampaignModel().get('mediaType') == 'mcbanner') {
            this._adjustBlock.setMinusWordsHint(
                iget2(
                    'b-phrase-popup',
                    'dobavlenie-minus-slova-k-104',
                    'Добавление минус-слова к фразе исключает показ баннера по всем запросам, содержащим это слово.'
                ));
        }

        return this;
    },

    /**
     * Cохранение фразы
     * @returns {BEM}
     * @private
     */
    _savePhrase: function() {
        this._hide();
        this.phraseModel.update(this.editPhraseModel.toJSON());

        return this;
    }
});
