BEM.DOM.decl('b-phrase-popup', {
    onSetMod: {
        js: function() {
            this._getPopup().setContent(BEMHTML.apply({
                block: 'b-phrase-popup',
                mods: { page: this.getMod('page') },
                elem: 'inner',
                mediaType: this.params.mediaType
            }));

            this._competitors = this.elem('competitors');
            this.bindTo('competitors', 'click', function(e) {
                e.preventDefault();

                BEM.blocks['b-metrika2'].params({
                    params: {
                        showCamp: {
                            'edit-phrase': 'competitors'
                        }
                    }
                });

                window.open(this.elem('competitors').attr('href'),
                    'competitors',
                    'width=700,height=600,status=yes,menubar=no,resizable=yes,scrollbars=1'
                ).focus();

                return false;
            });

            this._input = this.findBlockOn('input', 'input');
            this._input && this._input.on('blur', this._onInputChange, this);
        }
    },

    /**
     * Инициализация блока
     * @param {Object} params - данные о родителе
     * @returns {BEM}
     */
    init: function(params) {
        this.phraseModel = params.phraseModel;
        this.bannersGroupModel = params.bannersGroupModel;

        this.phraseModel.on(
            'change',
            function() {
                this._updateDisableSuspendMod();
                this._updateCompetitorsLink();
            },
            this);
        this.campModel = this.bannersGroupModel.getCampaignModel();

        this._updateCompetitorsLink();
        this._updateDisableSuspendMod();

        return this;
    },

    /**
     * Пока попапа
     * @param {BEM} owner - родитель
     * @returns {BEM}
     */
    show: function(owner) {
        this._getPopup().show(owner);

        return this;
    },

    /**
     * Показывает ошибки
     * @param {String} message
     * @returns {BEM}
     * @private
     */
    _showError: function(message) {
        BEM.blocks['b-user-dialog'].alert({
            message: message,
            parentPopup: this._getPopup()
        });

        return this;
    },

    /**
     * Отмена
     * @returns {*}
     */
    _cancel: function() {
        return this._hide();
    },

    /**
     * скрытие попапа
     * @returns {BEM}
     * @private
     */
    _hide: function() {
        this._getPopup().hide();

        return this;
    },

    /**
     * dвозвращает попапа
     * @returns {BEM}
     * @private
     */
    _getPopup: function() {
        return this.popup || (this.popup = this.findBlockOn('popup'));
    },

    /**
     * инициализация модели временной фразы
     * @returns {BEM}
     * @private
     */
    _initTmpModel: function() {
        //модель, в которую сохраняются временные значения для редактирования фразы
        this.editPhraseModel = BEM.MODEL.create({ name: 'm-phrase-tmp', id: 'tmp' })
            .on('phrase', 'change', this._onTmpPhraseChanged, this);

        return this;
    },

    /**
     * получение модели временной фразы
     * @returns {BEM}
     * @private
     */
    _getTmpModel: function() {
        if (!this.editPhraseModel) this._initTmpModel();

        return this.editPhraseModel;
    },

    /**
     * Событие, что несохраненная фраза была изменена
     * @private
     */
    _onTmpPhraseChanged: function() {
        this._input.val(this._getTmpModel().get('phrase'));
    },

    /**
     * Получения урла страницы "объявления конкурентов"
     * @returns {string}
     * @private
     */
    _getCompetitorsUrl: function() {
        var href = '?cmd=showCompetitors&nocid=' + this.campModel.get('cid') + '&id=' + this.phraseModel.get('id');

        if (this.campModel.get('platform') == 'context') {
            href += '&from=ctx';
        }

        return href;
    },

    /**
     * Обновление ссылки на объявления конкурентов
     * @private
     */
    _updateCompetitorsLink: function() {
        var href = this._getCompetitorsUrl();

        this._competitors.attr('href', href);
    },

    /**
     * Обновление отображения кнопки Остановить в зависимости от типа условия показа
     * @private
     */
    _updateDisableSuspendMod: function() {
        // ретаргетинги на поиске нельзя останавливать
        if (u.consts('isSearchRetargetingEnabled')) {
            this.setMod(
                'disable-suspend',
                this.phraseModel.get('state') === 'search' && this.getMod('type') === 'retargeting' ? 'yes' : ''
            );
        }
    },

    /**
     * Обработчик изменений на инпуте
     * @private
     */
    _onInputChange: function() {
        var phrase = $.trim(this._input.val()),
            tmpModel = this._getTmpModel(),
            data = {
                minus_words: u.phraseFormatter.getMinusWords(phrase),
                key_words: u.phraseFormatter.getKeyWords(phrase)
            };

        tmpModel.update(data, this);
        //вставляем в input облагороженное значение  DIRECT-16024
        this._input.val(tmpModel.get('phrase'));
    }
}, {

});
