block('b-phrase').mod('type', 'phrase')(

    def()(function() {
        return applyNext({
            phrase: this.ctx.phrase
        });
    }),

    content()(function() {
        var data = this.data,
            phrase = this.phrase,
            phraseId = this.ctx.phraseModelId,
            platform = this.ctx.platform;

        return [
            data.FORM.debug && !!data.is_internal_ip && [{
                block: 'link',
                attrs: {
                    target: '_blank'
                },
                url: u.formatUrl({
                    protocol: 'https',
                    host: 'yandex.' + u.consts('tld'),
                    path: 'yandsearch',
                    query: {
                        text: u.escapeHTML(phrase.phrase)
                    }
                }),
                content: [
                    '[',
                    {
                        block: 'b-phrase',
                        elem: 'srch',
                        content: 'Я' // eslint-disable-line require-iget2
                    },
                    ']'
                ]
            }, ' '],
            this.data.view_only ?
                {
                    block: 'b-help-link',
                    mods: {
                        decoration: 'no'
                    },
                    mix: {
                        block: 'b-pharse',
                        elem: 'view-only-link'
                    },
                    url: u.getUrl('showCompetitors', {
                        nocid: data.campaign.cid,
                        id: phraseId,
                        from: platform != 'context' ? '' : 'ctx'
                    }),
                    text: [
                        u.escapeHTML(phrase.key_words),
                        !!phrase.minus_words && {
                            block: 'b-phrase-minus-words',
                            mods: {
                                unglued: phrase.unglued ? 'on' : 'off'
                            },
                            phrase: phrase
                        }
                    ],
                    attrs: {
                        name: phraseId
                    }
                } :
                {
                    elem: 'content-wrap',
                    content: [
                        {
                            elem: 'content',
                            tag: 'span',
                            content: [
                                {
                                    elem: 'key-words-wrapper',
                                    tag: 'span',
                                    content: {
                                        block: 'b-phrase-key-words',
                                        phrase: phrase,
                                        mods: {
                                            fixation: phrase.stopword_fixated ? 'on' : 'off'
                                        }
                                    }
                                },
                                {
                                    elem: 'minus-words-wrapper',
                                    tag: 'span',
                                    content: {
                                        block: 'b-phrase-minus-words',
                                        mods: {
                                            unglued: phrase.unglued ? 'on' : 'off'
                                        },
                                        phrase: phrase
                                    }
                                }],
                            attrs: {
                                id: phraseId
                            }
                        },
                        '&nbsp;',
                        {
                            elem: 'edit-icon',
                            tag: 'img',
                            mix: [{
                                block: 'b-icon',
                                mods: {
                                    'size-16': 'edit'
                                }
                            }]
                        },
                        '&nbsp;',
                        {
                            elem: 'minus-words-expander',
                            tag: 'img',
                            mix: [{
                                block: 'b-icon',
                                mods: {
                                    'size-16': 'threedots'
                                }
                            }]
                        }
                    ]
                },
            {
                elem: 'warnplace',
                tag: 'span',
                elemMods: {
                    type: (function() {
                        if (u._.get(data, ['warnplace0', phraseId])) {
                            return 'guarantee';
                        }

                        if (u._.get(data, ['warnplace2', phraseId])) {
                            return 'spec';
                        }

                        return '';
                    })()
                },
                phrase: phrase
            },
            {
                elem: 'warnings',
                tag: 'span',
                phrase: phrase,
                group: this.ctx.group,
                platform: platform
            }
        ];
    }),

    elem('warnplace').elemMod('type', 'guarantee').content()(function() {
        return ' (' + iget2('b-phrase', 'byla-vytesnena-iz-poiska', 'была вытеснена из поиска') + ')';
    }),

    elem('warnplace').elemMod('type', 'spec').content()(function() {
        return ' (' + iget2('b-phrase', 'byla-vytesnena-iz-premium-pokazov', 'была вытеснена из премиум-показов') + ')';
    }),

    elem('warnings').content()(function() {
        var data = this.data,
            form = data.FORM,
            phrase = this.phrase;

        return [
            // картинка с буквой У
            // !!(this.phrase.showAutoOptimizationImg && this.ctx.platform != 'context') && {
            //     block: 'b-icon',
            //     mods: {
            //         'size-13': 'optimized'
            //     },
            //     attrs: {
            //         title: iget('Фраза после 1-го автоуточнения')
            //     },
            //     alt: iget('Фраза после 1-го автоуточнения')
            // },
            !!(form.debug && data.is_internal_ip && phrase.bs_url) && {
                block: 'link',
                mix: [{
                    block: 'b-phrase',
                    elem: 'bs'
                }],
                content: '[BS]',
                url: phrase.bs_url
            },
            !!(form.debug && data.is_internal_ip) && {
                block: 'b-phrase',
                tag: 'span',
                elem: 'internal',
                content: '(' +
                    'id:' + phrase.id +
                    ', PhraseID:' + phrase.PhraseID +
                    ', statusModerate: ' + phrase.statusModerate +
                    ', bsIdHistory: ' + (phrase.bsIdHistory || '-') +
                    ')'
            },
            !!(phrase.t_lowctr && this.platform != 'context') && {
                block: 'b-help-link',
                url: u.getHelpUrl('increase-ctr') + '&adgroup_id=' + this.ctx.group.adgroup_id + '&edit=0',
                mods: {
                    decoration: 'no'
                },
                icon: 'notice',
                title: iget2('b-phrase', 'fraza-imeet-nizkuyu-effektivnost', 'Фраза имеет низкую эффективность')
            }

        ];
    })
);
