BEM.DOM.decl({ block: 'b-phrase', modName: 'type', modVal: 'phrase' }, {
    onSetMod: {
        js: function() {
            this.__base();
            this.phraseModel
                //debounce нужен чтобы не дергать события 100500 раз, когда по update меняются 100500 полей модели
                //событие на key_words_fix_on и key_words_fix_off нужно когда приходят новые корректировки с сервера
                //событие на stopword_fixated нужно когда вручную включаем/отключаем корректировку
                .on(
                    'key_words stopword_fixated key_words_fix_on key_words_fix_off',
                    'change',
                    $.debounce(this.onKeyWordsChanged, 50, this),
                    this
                )
                //событие на phrase_unglued_suffix нужно когда приходят новые корректировки с сервера
                //событие на unglued нужно когда вручную включаем/отключаем корректировку
                .on(
                    'minus_words unglued phrase_unglued_suffix',
                    'change',
                    $.debounce(this.onMinusWordsChanged, 50, this),
                    this
                );

            this.campaignModel.on('minus_words', 'change', this.onMinusWordsChanged, this);
            this.bannersGroupModel.on('minus_words', 'change', this.onMinusWordsChanged, this);

            this.findBlockInside('minus-words-wrapper', 'b-phrase-minus-words').init(this.phraseModel);
            this.findBlockInside('key-words-wrapper', 'b-phrase-key-words').init(this.phraseModel);
            //синхронизируемся с моделью
            this.phraseModel.isChanged() && this.onKeyWordsChanged();
        }
    },

    onKeyWordsChanged: function() {
        BEM.DOM.update(this.elem('key-words-wrapper'), BEMHTML.apply({
            block: 'b-phrase-key-words',
            phrase: this.phraseModel.toJSON(),
            mods: { fixation: this.phraseModel.get('stopword_fixated') ? 'on' : 'off' }
        }));

        this.findBlockInside('key-words-wrapper', 'b-phrase-key-words').init(this.phraseModel);
    },

    onMinusWordsChanged: function() {
        var phraseModel = this.phraseModel,
            minusWords = phraseModel.get('minus_words'),
            ungluedSuffix = phraseModel.get('unglued') ? phraseModel.get('phrase_unglued_suffix') : '',
            inline = ((u.minusWords.arrayToString(minusWords).length + ungluedSuffix.length) <
                +phraseModel.get('phrase_minus_words_limit')) &&
                    !this.bannersGroupModel.get('minus_words').length &&
                        !this.campaignModel.get('minus_words').length;

        this.setMod('minus-words-type', inline ? 'inline' : 'popup');

        BEM.DOM.update(this.elem('minus-words-wrapper'), BEMHTML.apply({
            block: 'b-phrase-minus-words',
            phrase: this.phraseModel.toJSON(),
            mods: { unglued: this.phraseModel.get('unglued') ? 'on' : 'off' }
        }));

        this.findBlockInside('minus-words-wrapper', 'b-phrase-minus-words').init(this.phraseModel);
    },

    toggleMinusWordsPopup: function() {
        this.minusWordPopup = this.minusWordPopup || this.__self.getMinusWordsPopup();
        this.minusWordPopup.toggle(
            this.elem('minus-words-expander'),
            this.phraseModel,
            this.bannersGroupModel.get('minus_words'),
            this.campaignModel.get('minus_words'));
    },

    destruct: function() {
        this.phraseModel.un(
            'key_words stopword_fixated key_words_fix_on key_words_fix_off minus_words unglued phrase_unglued_suffix',
            'change'
        );

        this.campaignModel.un('minus_words', 'change');
        this.bannersGroupModel.un('minus_words', 'change');

        this.__base.apply(this, arguments);
    }
}, {

});
