BEM.DOM.decl({ block: 'b-phrase', modName: 'type', modVal: 'relevance-match' }, {

    onSetMod: {
        js: function() {
            this.__base();

            this.campaignModel.on('minus_words', 'change', this.onMinusWordsChanged, this);
            this.bannersGroupModel.on('minus_words', 'change', this.onMinusWordsChanged, this);

            // relevance-match-info-icon
            // Подсказка, показывается если стратегия блокирует автотаргетинг на определенной площадке.
            // Контрол настройки автотаргетинга не даст выбрать заблокированную площадку,
            // поэтому после изменений настроек подсказка становится неактуально(удаляем)
            if (this.elem('relevance-match-info-icon').length) {
                this.phraseModel.on('search_stop net_stop', 'change', function() {
                    BEM.DOM.destruct(this.elem('relevance-match-info-icon'));
                }, this);
            }
        }
    },

    toggleMinusWordsPopup: function() {
        this.minusWordPopup = this.minusWordPopup || this.__self.getMinusWordsPopup();
        this.minusWordPopup.toggle(
            this.elem('minus-words-expander'),
            this.phraseModel,
            this.bannersGroupModel.get('minus_words'),
            this.campaignModel.get('minus_words')
        );
    },

    onMinusWordsChanged: function() {
        var inline = !this.bannersGroupModel.get('minus_words').length && !this.campaignModel.get('minus_words').length;

        this.setMod('minus-words-type', inline ? 'inline' : 'popup');

        BEM.DOM.update(this.elem('minus-words-wrapper'), BEMHTML.apply({
            block: 'b-phrase-minus-words',
            phrase: this.phraseModel.toJSON(),
            mods: { unglued: this.phraseModel.get('unglued') ? 'on' : 'off' }
        }));
    },

    /**
     * Обработчик наведения/ухода с иконки
     * @param {Event} e
     * @private
     */
    _onIconOverOut: function(e) {
        if (e.type === 'pointerover') {
            this._showTooltip(e.data.domElem);
        } else {
            this._hideTooltip();
        }
    },

    /**
     * Показывает тултип про авторасчет ставки
     * @param {jQuery} elem
     * @private
     */
    _showTooltip: function(elem) {
        this._tipman || (this._tipman = BEM.create('tipman', {
            tipMods: { theme: 'normal' },
            popupDirections: ['right', 'bottom'],
            delay: 50
        }));

        this._tipman.show({
            owner: elem,
            content: BEMHTML.apply({
                block: 'b-phrase',
                elem: 'relevance-match-info-tooltip',
                content: this.elemParams(elem).info
            })
        });
    },

    /**
     * Прячет тултип про авторасчет ставки
     * @private
     */
    _hideTooltip: function() {
        this._tipman && this._tipman.hide();
    }

}, {

});
