block('b-phrase').mod('type', 'retargeting')(
    addJs()(true),

    content()(function() {
        var phrase = this.ctx.phrase,
            retCondId = phrase.ret_cond_id,
            retData = this.data.all_retargeting_conditions[retCondId],
            groups = retData.condition || [],
            isAccessible = +u._.get(retData, 'is_accessible') === 1,
            isInterests = u['retargeting'].isConditionType(retData, 'interests'),
            arrayToHash = function(array) {
                return (array || []).reduce(function(hash, item) {
                    hash[item.id] = item;
                    return hash;
                }, {});
            };

        return [
            {
                elem: 'content-wrap',
                content: [
                    {
                        elem: 'content',
                        tag: 'span',
                        content: '"' + phrase.condition_name_escape + '"',
                        attrs: {
                            id: this.ctx.group.adgroup_id + ':' + this.ctx.phraseModelId
                        }
                    },
                    '&nbsp;',
                    {
                        elem: 'edit-icon',
                        tag: 'span',
                        mix: [{
                            block: 'b-icon',
                            mods: {
                                'size-16': 'edit'
                            }
                        }]
                    },
                    phrase.condition_name_escape !== phrase.condition_name && [
                        '&nbsp;',
                        {
                            elem: 'condition-expander',
                            tag: 'img',
                            mix: [{
                                block: 'b-icon',
                                mods: {
                                    'size-16': 'threedots'
                                }
                            }]
                        }
                    ],
                    !isAccessible && [
                        '&nbsp;',
                        {
                            block: 'icon',
                            mods: {
                                'size-12': 'alert'
                            },
                            mix: [
                                {
                                    block: this.block,
                                    elem: 'unaccessable-hint'
                                },
                                {
                                    block: 'b-hintable',
                                    js: {
                                        hint: iget2(
                                            'b-phrase',
                                            'uslovie-conditionname-mozhet-rabotat',
                                            'Условие "{conditionName}" может работать неправильно. Цели и/или сегменты "{conditionName}" — входящие в условие, были удалены, или стали недоступны по другой причине.',
                                            {
                                                conditionName: phrase.condition_name
                                            }
                                        )
                                    }
                                }
                            ]
                        }
                    ]
                ]
            },
            isInterests && {
                elem: 'interests',
                content: groups.length ? [
                    {
                        block: 'crypta-summary',
                        data: {
                            interests: u._.cloneDeep(groups).map(function(group) {
                                group.goals = (group.goals || []).map(function(goal) {
                                    return {
                                        id: goal.goal_id,
                                        type: goal.goal_type,
                                        time: goal.time
                                    }
                                });

                                return group;
                            })
                        },
                        segments: arrayToHash(this.data.java_crypta_segments),
                        goals: arrayToHash(this.data.java_retargeting_goals)
                    }
                ] : iget2(
                    'b-phrase',
                    'all-audience',
                    'Вся аудитория'
                )
            }
        ];
    })
);
