(function() {
    //TODO повторяются в b-campaign-edit-panel - подумать в какой блок вынести
    var CHANGED_FIELDS = {
        phrase: ['phrase_unglued_suffix', 'minus_words', 'key_words'],
        retargeting: [],
        interest: [],
        'relevance-match': []
    };

    BEM.DOM.decl('b-phrase', {
        onSetMod: {
            js: function() {
                this.findBlockOutside('b-group-phrase');

                this.phraseModel = BEM.MODEL.getOrCreate(this.params.modelParams)
                    .on('fix', function() {
                        this.setMod('changed', 'no');
                    }, this)
                    .on('change', function() {
                        this.setMod('changed', this.isPhraseChanged() ? 'yes' : 'no');
                    }, this);

                this.bannersGroupModel = this.phraseModel.getParentModel();

                this.campaignModel = this.bannersGroupModel.getCampaignModel();
            }
        },

        isPhraseChanged: function() {
            var changed = false;

            CHANGED_FIELDS[this.getMod('type')].forEach(function(fieldName) {
                changed = changed || this.phraseModel.isChanged(fieldName);
            }, this);

            return changed;
        },

        showEditPopup: function() {
            var mediaType = this.campaignModel.get('mediaType'),
                popup = this.__self.getPopup(mediaType);

            BEM.blocks['b-campaign-edit-panel'].getInstance().clear();
            popup.setMod('type', this.getMod('type')).init({
                phraseModel: this.phraseModel,
                parentDomElem: this.domElem,
                bannersGroupModel: this.bannersGroupModel
            });

            this.afterCurrentEvent(function() { //DIRECT-28738 нужно для того, чтобы не начал рисоваться transition
                popup.show(this.domElem);
            });

            return this;
        },

        /**
         * Показывает объявления конкурентов
         */
        showCompetitorsAd: function() {
            //todo: OpenWindow?
            window.open(BEM.blocks['i-utils'].getUrl('showCompetitors', {
                nocid: this.campaignModel.get('cid'),
                id: this.phraseModel.get('id'),
                from: this.campaignModel.get('platform') == 'context' ? 'ctx' : undefined
            }), '', 'width=700,height=600,status=yes,menubar=no,resizable=yes,scrollbars=1');
        },

        toggleMinusWordsPopup: function() {
            //implemented in subclasses
        },

        _onIconOverOut: function() {
            //implemented in subclasses
        }

    }, {
        live: function() {
            this
                .liveBindTo('content', 'touchstart click', function() {
                    if (this.hasMod('editable', 'yes')) {
                        this.showEditPopup();
                    } else if (this.hasMod('clickable', 'yes')) {
                        this.showCompetitorsAd();
                    }
                })
                .liveBindTo('condition-expander', 'touchstart click', function() {
                    this.showRetargetingPopup();
                })
                .liveBindTo('minus-words-expander', 'touchstart click', function() {
                    this.toggleMinusWordsPopup();
                })
                .liveBindTo('relevance-match-info-icon', 'pointerover pointerout', function(e, data) {
                    this._onIconOverOut(e, data);
                });
        },

        /**
         * @returns {*|BEM|jQuery}
         */
        getPopup: function(mediaType) {
            return this._editPopup || (this._editPopup = $(BEMHTML.apply({
                block: 'b-phrase-popup',
                mods: { adjusted: 'no', page: 'campaign' },
                mediaType: mediaType
            })).appendTo(BEM.blocks['b-page'].getInstance().domElem).bem('popup').findBlockOn('b-phrase-popup'))
        },

        getMinusWordsPopup: function() {
            return this._minusWordsPopup || (this._minusWordsPopup = $(BEMHTML.apply({
                block: 'b-phrase-minus-words-popup',
                js: true
            })).appendTo(BEM.blocks['b-page'].getInstance().domElem).bem('b-phrase-minus-words-popup'));
        }

    });

})();
