block('b-phrases-auction-popup')(

    elem('popup-content')(
        content()(function() {
            var ctx = this.ctx,
                tabsContent = [],
                panesContent = [];

            if (ctx.auctionData && ctx.auctionData.nobsdata) {
                return iget2('b-phrases-auction-popup', 'po-tehnicheskim-prichinam-vremenno', 'По техническим причинам временно нет данных.');
            }

            if (ctx.hasPrice) {
                tabsContent.push({
                    elem: 'tab',
                    elemMods: { active: 'yes' },
                    content: {
                        block: 'link',
                        content: iget2('b-phrases-auction-popup', 'na-poiske', 'На поиске')
                    }
                });

                panesContent.push({
                    elem: 'pane',
                    elemMods: { active: 'yes' },
                    content: {
                        block: 'b-phrases-auction',
                        mods: { type: 'search' },
                        mix: {
                            block: 'b-phrases-auction-popup',
                            elem: 'auction'
                        },
                        strategy: ctx.campaign.strategy,
                        campType: ctx.campaign.type,
                        currency: ctx.currency,
                        auctionData: ctx.auctionData
                    }
                });
            }

            if (ctx.hasPriceContext) {
                tabsContent.push({
                    elem: 'tab',
                    elemMods: { active: ctx.hasPrice ? '' : 'yes' },
                    content: {
                        block: 'link',
                        content: iget2('b-phrases-auction-popup', 'v-setyah', 'В сетях')
                    }
                });

                panesContent.push({
                    elem: 'pane',
                    elemMods: { active: ctx.hasPrice ? '' : 'yes' },
                    content: {
                        block: 'b-phrases-auction',
                        mods: { type: 'context' },
                        mix: {
                            block: 'b-phrases-auction-popup',
                            elem: 'auction'
                        },
                        currency: ctx.currency,
                        auctionData: ctx.auctionData
                    }
                });
            }

            return [
                {
                    block: 'b-phrases-auction-popup',
                    elem: 'title',
                    content: iget2('b-phrases-auction-popup', 'stavka-klyuchevoy-frazy', 'Ставка ключевой фразы')
                },
                {
                    block: 'tabs',
                    mods: {
                        control: 'menu',
                        size: 's',
                        theme: 'normal-red',
                        layout: 'horiz'
                    },
                    panes: 'tabs-' + ctx.modelId,
                    content: tabsContent
                },
                {
                    block: 'tabs-panes',
                    id: 'tabs-' + ctx.modelId,
                    content: panesContent
                }
            ];
        })
    )

);
