BEM.DOM.decl('b-phrases-auction-popup', {

    /**
     * Возвращает инстанс i-request
     * @returns {BEM}
     * @private
     */
    _request: function() {
        return this._requestInstance || (this._requestInstance = BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            type: 'POST',
            cache: false,
            dataType: 'json',
            callbackCtx: this
        }));
    },

    /**
     * Делает запрос на сервер. Возвращает данные от торгов и показометра
     * https://wiki.yandex-team.ru/Direkt/TechnicalDesign/mol-add-plus-phrases/#kontrollerajaxgetphrasesauction
     * @returns {$.Deferred}
     */
    getPhrasesAuction: function() {
        var deferred = $.Deferred();

        this._request().get({
            cmd: 'ajaxGetPhrasesAuction',
            json_stat_phrases: JSON.stringify([{
                phrase: this._getModel().get('phrase'),
                pid: this._getModel().get('adgroup_id')
            }])
        },
        function(result) {
            result.error ?
                deferred.rejectWith(this, [result.error]) :
                deferred.resolveWith(this, arguments);
        },
        function(error) {
            deferred.rejectWith(this, arguments)
        });

        return deferred.promise();
    },

    /**
     * Возвращает модель фразы
     * @returns {BEM}
     * @private
     */
    _getModel: function() {
        return this._model = this._model || BEM.MODEL.getOne(this.params.modelParams);
    },

    /**
     * Открывает попап, добавляет таблицу от торгов
     * @param {jQuery.Event} e
     * @private
     */
    _onIconClick: function(e) {
        var tabs = this.params.tabs || { search: true, context: true };

        this._popup = BEM.blocks['b-shared-popup'].getInstance({
            adaptive: 'yes',
            animate: 'no',
            'has-close': 'yes'
        }, {
            directions: ['right', 'top']
        }, {
            popup: { block: 'b-phrases-auction-popup', elem: 'popup' }
        });

        this._popup.on('hide', this._onPopupHide, this);

        // спиннер вставляется до тех пор, пока не разрезолвится запрос и не вставятся полученные данные в контент
        this._popup.setContent(BEMHTML.apply({
            block: 'spin2',
            mods: { size: 'l', progress: 'yes' },
            js: true,
            mix: {
                block: 'b-phrases-auction-popup',
                elem: 'spin'
            }
        }));

        this._popup.toggle($(e.target));

        this.getPhrasesAuction()
            .then(function(data) {
                this._popup.setContent(BEMHTML.apply({
                    block: 'b-phrases-auction-popup',
                    elem: 'popup-content',
                    auctionData: data[0],
                    campaign: this.params.campaign,
                    currency: this.params.currency,
                    modelId: this._getModel().get('modelId'),
                    hasPrice: tabs['search'] && this._getModel().get('has_price'),
                    hasPriceContext: tabs['context'] && this._getModel().get('has_price_context')
                }));
            });
    },

    /**
     * Обрывает запрос, отписывается от попапа
     * @private
     */
    _onPopupHide: function() {
        this._requestInstance && this._requestInstance.abort();
        this._popup.un('hide', this._onPopupHide);
    },

    /**
     * Уничтожает блок, обрывает запрос
     * @returns {BEM}
     */
    destruct: function() {
        this._requestInstance && this._requestInstance.abort();
        this._popup && this._popup.destruct();

        return this.__base.apply(this, arguments);
    }

}, {

    live: function() {

        this.liveBindTo('switcher-icon', 'pointerclick', function(e, data) {
            this._onIconClick(e);
        });

    }

});
