block('b-phrases-auction')(

    mod('type', 'context')(
        content()(function() {
            var priceForCoverage = this.ctx.auctionData.price_for_coverage || {},
                audienceCoverageRows = ['100', '50', '20'],
                priceRows = audienceCoverageRows.map(function(name) {
                    return u.numberFormatter.round(priceForCoverage[name]) && priceForCoverage[name];
                });

            return {
                elem: 'table',
                content: [
                    {
                        elem: 'row',
                        elemMods: { type: 'head' },
                        content: [
                            {
                                elem: 'cell',
                                content: iget2('b-phrases-auction', 'ohvat-auditorii', 'Охват аудитории')
                            },
                            {
                                elem: 'cell',
                                content: [
                                    iget2('b-phrases-auction', 'bid', 'Ставка') + ',&nbsp;',
                                    {
                                        block: 'b-phrases-auction',
                                        elem: 'currency',
                                        content: u.currencies.getName(this.ctx.currency)
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        elem: 'row',
                        content: [
                            {
                                elem: 'cell',
                                content: [
                                    {
                                        elem: 'aligner',
                                        content: [
                                            // Охват аудитории 100%, 50%, 20%
                                            audienceCoverageRows.map(function(name) {
                                                return {
                                                    elem: 'cell-aligned',
                                                    elemMods: { align: 'right' },
                                                    content: name + '%'
                                                }
                                            })
                                        ]
                                    }
                                ]
                            },
                            {
                                elem: 'cell',
                                content: [
                                    {
                                        elem: 'aligner',
                                        content: [
                                            // Охват аудитории 100%, 50%, 20%
                                            priceRows.map(function(price) {
                                                return {
                                                    elem: 'cell-aligned',
                                                    elemMods: { align: 'right' },
                                                    content: price || '&mdash;'
                                                }
                                            })
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ]
            };
        })
    )

);
