block('b-phrases-auction')(

    mod('type', 'search')(
        content()(function() {
            var phrase = this.ctx.auctionData,
                isMcbanner = this.ctx.campType === 'mcbanner',
                cells = isMcbanner ?
                    [{ data: phrase.price_for_mcbanner[0] }] :
                    u['traffic-volume'].getTrafficVolumeKeys(phrase.traffic_volume, true).map(function(name) {
                        return {
                            name: name,
                            data: phrase.traffic_volume[name]
                        };
                    });

            if (!cells.length) {
                return {
                    elem: 'no-data-message',
                    content: iget2('b-phrases-auction', 'no-data-message', 'Для этого условия показа нет данных.')
                };
            }

            return {
                elem: 'table',
                content: [
                    {
                        elem: 'row',
                        elemMods: { type: 'head' },
                        content: [
                            {
                                elem: 'cell',
                                elemMods: { align: 'right' },
                                content: iget2('b-phrases-auction', 'traffic-volume', 'Объём<br/>трафика')
                            },
                            {
                                elem: 'cell',
                                elemMods: { align: 'right' },
                                content: [
                                    iget2('b-phrases-auction', 'bid-forecast', 'Прогноз<br/>ставки') + ', ',
                                    {
                                        block: 'b-phrases-auction',
                                        elem: 'currency',
                                        content: u.currencies.getName(this.ctx.currency)
                                    }
                                ]
                            },
                            {
                                elem: 'cell',
                                elemMods: { align: 'right' },
                                content: [
                                    iget2('b-phrases-auction', 'spisyvaemaya-br-cena', 'Списываемая<br/>цена') + ', ',
                                    {
                                        block: 'b-phrases-auction',
                                        elem: 'currency',
                                        content: u.currencies.getName(this.ctx.currency)
                                    }
                                ]
                            }
                        ]
                    },
                    cells.map(function(item) {
                        var priceData = item.data;

                        return {
                            elem: 'row',
                            content: [
                                {
                                    elem: 'cell',
                                    elemMods: { align: 'right' },
                                    content: item.name
                                },
                                {
                                    elem: 'cell',
                                    elemMods: { align: 'right' },
                                    content: priceData ?
                                        priceData.dont_show_bid_price ?
                                            { block: 'b-group-phrase', elem: 'dont-show-bid-price', isMcbanner: isMcbanner } :
                                            u.numberFormatter.format(priceData.bid_price / 1e6) :
                                        '&mdash;'
                                },
                                {
                                    elem: 'cell',
                                    elemMods: { align: 'right' },
                                    content: priceData ?
                                        priceData.dont_show_bid_price ?
                                            { block: 'b-group-phrase', elem: 'dont-show-bid-price', isMcbanner: isMcbanner } :
                                            u.numberFormatter.format(priceData.amnesty_price / 1e6) :
                                        '&mdash;'
                                }
                            ]
                        };
                    })
                ]
            };
        })
    )

);
