block('b-phrases-corrections-message')(

    tag()('li'),

    js()(function() {
        return {
            corrections: this.ctx.corrections,
            modelParams: this.ctx.modelParams,
            type: this.ctx.type
        };
    }),

    def()(function() {
        var ctx = this.ctx;

        if (ctx.type == 'stopword-fixated') {
            ctx.corrections = ctx.corrections.map(function(correction) {
                //todo старый говнокод - подумать, как переписать красиво
                correction.fixation.map(function(fix) {
                    correction.message = correction.phrase
                        .replace(
                            new RegExp('((\\s|^)' + fix[0].replace(/\+/g, '\\+') + ')'),
                            '$2<span class="b-phrases-corrections-message__bold">' + fix[0] + '</span>'
                        );
                });

                return correction;
            }, this)
        } else {
            ctx.corrections = ctx.corrections.map(function(correction) {
                correction.message = [
                    {
                        block: 'b-phrases-corrections-message',
                        elem: 'keywords',
                        content: correction.key_words
                    },
                    '&nbsp;',
                    {
                        block: 'b-phrases-corrections-message',
                        elem: 'minus-words',
                        content: correction.phrase_unglued_suffix
                    }
                ];

                return correction;
            }, this)
        }

        return applyNext();
    }),

    content()(function() {
        return {
            block: 'b-toggle',
            content: [
                this.ctx.type == 'unglued' ?
                    iget2(
                        'b-phrases-corrections-message',
                        'dobavleny-minus-slova-dlya',
                        'добавлены минус-слова для разделения пересекающихся фраз'
                    ) :
                    iget2(
                        'b-phrases-corrections-message',
                        'vklyuchen-obyazatelnyy-uchet-nekotoryh',
                        'включен обязательный учет некоторых стоп-слов'
                    ),
                {
                    elem: 'toggle',
                    mix: [{
                        block: 'b-phrases-corrections-message',
                        elem: 'toggle'
                    }],
                    current: 0,
                    items: [
                        {
                            elem: 'link',
                            content: iget2('b-phrases-corrections-message', 'razvernut', 'Развернуть')
                        },
                        {
                            elem: 'link',
                            content: iget2('b-phrases-corrections-message', 'svernut', 'Свернуть')
                        }
                    ]
                },
                {
                    elem: 'toggle',
                    state: 'hidden',
                    items: [
                        [
                            {
                                elem: 'corrections-cancel',
                                block: 'b-phrases-corrections-message'
                            },
                            {
                                block: 'b-phrases-corrections-message',
                                elem: 'corrections-list',
                                content: this.ctx.corrections.map(function(correction) {
                                    return {
                                        block: 'b-phrases-corrections-message',
                                        elem: 'message',
                                        adgroupId: correction.adgroupId,
                                        message: correction.message
                                    }
                                })
                            }
                        ]
                    ]
                }
            ]
        };
    }),

    elem('corrections-cancel').content()(function() {
        return {
            block: 'b-toggle',
            content: {
                elem: 'toggle',
                items: [
                    {
                        elem: 'link',
                        content: iget2('b-phrases-corrections-message', 'otmenit-korrektirovku', 'Отменить корректировку')
                    },
                    {
                        elem: 'link',
                        content: iget2('b-phrases-corrections-message', 'vklyuchit-korrektirovku', 'Включить корректировку')
                    }
                ]
            }
        };
    }),

    elem('message').content()(function() {
        return [
            this.ctx.adgroupId && {
                elem: 'link',
                bid: this.ctx.adgroupId
            },
            {
                elem: 'text',
                content: [
                    this.ctx.adgroupId && ': ',
                    this.ctx.message
                ]
            }
        ];
    }),

    elem('link').content()(function() {
        return {
            block: 'link',
            url: '#' + this.ctx.adgroupId,
            content: ['M-', this.ctx.adgroupId]
        };
    })
);
