/**
 * @event b-phrases-corrections-message#toggle
 * @type {Object}
 * @property {Boolean} isRejected была ли отменена корректировка
 */

/**
 * @fires {b-phrases-corrections-message#toggle}
 */
BEM.DOM.decl('b-phrases-corrections-message', {
    onSetMod: {
        js: function() {
            this.isRejected = false;
            this.corrections = this.params.corrections;
            this.campModel = BEM.MODEL.getOne(this.params.modelParams);
            this.toggle = this.findBlockInside('corrections-cancel', 'b-toggle')
                .on('change', this.onCorrectionsCancel, this);
        }
    },

    getRequest: function() {
        return this._request || (this._request = BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            dataType: 'json',
            cache: false,
            type: 'POST',
            callbackCtx: this
        }));
    },

    getCorrectionsData: function() {
        var data = {};

        this.corrections.forEach(function(dataBlock) {
            var adgroupId = dataBlock.adgroup_id;

            !data[adgroupId] && (data[adgroupId] = {});
            data[adgroupId][dataBlock.id] = (this.params.type == 'unglued') ?
                dataBlock.phrase_unglued_suffix :
                dataBlock.fixation;
        }, this);

        return JSON.stringify(data);
    },

    onCorrectionsCancel: function() {
        var _this = this;

        this.isRejected = !this.isRejected;

        this.trigger('toggle', {
            isRejected: this.isRejected
        });

        if (this.getMod('ajax') != 'yes') {
            $.when(BEM.blocks['b-groups-list'].initPhrasesLists()).done(function() {
                _this.onCancelSuccess();
            });

            return this;
        }

        this.getRequest().get({
            cid: this.campModel.get('cid'),
            is_rejected: +this.isRejected,
            ulogin: u.consts('ulogin'),
            cmd: 'ajaxApplyRejectCorrection',
            correction: this.params.type,
            json_phrases: this.getCorrectionsData()
        }, function(data) {
            this.onCancelSuccess();
        }, function() {
            this.campModel.trigger('error', [{ text: iget2(
                'b-phrases-corrections-message',
                'ne-udalos-sohranit-dannye',
                'Не удалось сохранить данные. Пожалуйста, попробуйте позже.'
            ) }]);
        });
    },

    onCancelSuccess: function() {
        var type = this.params.type,
            phraseModelId,
            model;

        this.corrections.forEach(function(correction) {
            phraseModelId = correction.modelId;

            model = BEM.MODEL.getOne({
                id: phraseModelId,
                name: 'm-phrase-bidable',
                parentName: correction.parentName,
                parentId: correction.parentId
            });
           //если поменялся id фразы - сохраняем его
            //phrases && phrases[correction.bannerId] && this.saveNewPid(correction.id, phrases[correction.bid][correction.pid]);
            if (type == 'unglued') {
                model
                    .update({ unglued: !this.isRejected })
                    .fix();
            } else {
                model
                    .update({ stopword_fixated: !this.isRejected })
                    .fix();
            }
        }, this);
    }
}, {

});
