block('b-phrases-corrections')(
    def()(function() {
        var phrasesCount = 0,
            corrections = {
                unglued: [],
                stopword_fixated: []
            };

        this.data.campaign.groups.forEach(function(group) {
            phrasesCount += group.phrases.length;
            group.phrases.forEach(function(phrase) {
                if (phrase.fixation) corrections.stopword_fixated.push(phrase);
                if (phrase.phrase_unglued_suffix) corrections.unglued.push(phrase);
            });
        });

        return applyNext({
            corrections: corrections,
            correctionsCount: corrections.stopword_fixated.length + corrections.unglued.length,
            phrasesCount: phrasesCount
        });

    }),

    addJs()(function() {
        return {
            correctionsCount: this.correctionsCount,
            phrasesCount: this.phrasesCount
        };
    }),

    content()(function() {
        return ['unglued', 'stopword_fixated'].map(function(type) {
            return !!this.corrections[type] && !!this.corrections[type].length && {
                block: 'b-phrases-corrections-message',
                modelParams: this.ctx.modelParams,
                type: type,
                corrections: this.corrections[type]
            };
        }, this);
    })
);
