/**
 * @typedef {Object} ToggleCorrectionsCallbackData
 * @params {Boolean} isRejected была ли отменена корректировка
 */

BEM.DOM.decl('b-phrases-corrections', {
    onSetMod: {
        js: function() {
            BEM.blocks['b-metrika2'].params({ params: { 'words-correction': true } });

            BEM.blocks['b-phrases-corrections-message'].on(
                this.domElem,
                'toggle',
                this._onToggleCorrectionsClick,
                this
            );
        }
    },

    /**
     * Колбек клика по отмене/возврату корректировки
     * @param {jQuery.Event} e
     * @param {ToggleCorrectionsCallbackData} data
     */
    _onToggleCorrectionsClick: function(e, data) {
        var isRejected = data.isRejected,
            params = isRejected ? {
                'words-correction': {
                    action: 'disable',
                    corrections_count: this.params.correctionsCount,
                    phrases_count: this.params.phrasesCount
                }
            } : {
                'words-correction': {
                    action: 'enable'
                }
            };

        BEM.blocks['b-metrika2'].params({ params: params });
    }
});
