block('b-phrases-input')(

    def()(function() {
        var ctx = this.ctx,
            newPhrases = ctx.group.new_phrases || [];

        return applyNext({
            newPhrases: newPhrases,
            group: ctx.group,
            page: ctx.page,
            charsLimit: ctx.charsLimit,
            disabled: newPhrases.length ? '' : 'yes'
        });
    }),

    content()(function() {
        return [
            {
                elem: 'hidden',
                attrs: {
                    type: 'hidden',
                    value: this.newPhrases.join(','),
                    name: this.ctx.fieldName
                },
                tag: 'input'
            },
            {
                block: 'input',
                mods: {
                    type: 'textarea'
                },
                value: this.newPhrases.join(', '),
                content: {
                    elem: 'control',
                    mix: [{
                        block: 'b-phrases-input',
                        elem: 'phrases-textarea'
                    }],
                    attrs: {
                        cols: '50'
                    }
                }
            },
            this.ctx.charsLimit != 'off' ?
                {
                    block: 'b-phrases-input',
                    elem: 'counter'
                } :
                '',
            {
                block: 'link',
                mods: {
                    pseudo: 'yes',
                    inner: 'yes',
                    disabled: this.disabled
                },
                mix: [{
                    block: 'b-phrases-input',
                    elem: 'button',
                    elemMods: {
                        name: 'clear'
                    }
                }],
                content: [
                    {
                        block: 'icon',
                        mods: { 'size-12': 'clear' },
                        mix: [{ block: 'link', elem: 'icon' }]
                    },
                    {
                        elem: 'inner',
                        content: iget2('b-phrases-input', 'ochistit', 'очистить')
                    }
                ]
            },
            {
                block: 'link',
                mods: {
                    pseudo: 'yes',
                    inner: 'yes',
                    disabled: this.disabled
                },
                mix: [{
                    block: 'b-phrases-input',
                    elem: 'button',
                    elemMods: { name: 'split' }
                }],
                content: [
                    {
                        block: 'icon',
                        mods: { 'size-12': 'refine' },
                        mix: [{ block: 'link', elem: 'icon' }]
                    },
                    {
                        elem: 'inner',
                        content: iget2('b-phrases-input', 'uporyadochit-i-utochnit', 'упорядочить и уточнить')
                    }
                ]
            }
        ];
    })
);
