(function($) {
/*jshint -W015*/

    var bemBlocks = BEM.blocks['i-utils'],
        bConfirm = BEM.blocks['b-confirm'];

    BEM.DOM.decl('b-phrases-input', {
        onSetMod: {
            js: function() {
                this.phrasesCounter = 0;

                this.inputDebounceChange = $.debounce(function() {
                    this.groupModel.set(
                        'new_phrases',
                        this._phrasesStrToArray(this.phrasesInput.val()), { source: this, ignore: this._isSorting }
                    );
                    this._isSorting = false;

                    this.trigger('change');
                }, 100);

                this.phrasesInput = this.findBlockInside('input')
                .on('change', this.inputDebounceChange, this);

                this.initButtons();

                this.initModel();
            },

            'phrases-status': function(modName, modVal) {
                var disabled = modVal == 'empty' ? 'yes' : '';

                Object.keys(this.buttons).forEach(function(name) {
                    this.buttons[name].setMod('disabled', disabled)
                }, this);
            }
        },

        _testPhrases: function() {
            !this._testPhrasesRequest && (this._testPhrasesRequest = BEM.create('i-request_type_ajax', {
                url: '/registered/main.pl',
                type: 'POST',
                cache: false,
                dataType: 'xml',
                callbackCtx: this
            }));

            this._testPhrasesRequest.get(
                {
                    cmd: 'ajaxTestPhrases',
                    phrases: this._toStringList([].concat(this.groupModel.get('new_phrases')))
                },
            function(result) {
                var error = $(result).find('error');

                error.length ?
                    bConfirm.open({ message: error.html(), type: 'alert', overflowHidden: true }) :
                    this.splitPhrases(result);
            }
        )
        },

    /**
     * Разбиваем фразы
     * @returns {BEM}
     */
        splitPhrases: function(result) {
            var model,
                phrases = $.map($(result).find('phrase'), function(p) { return $(p).text(); });

            phrases.forEach(function(phrase) {
                model = BEM.MODEL.create(
                    {
                        name: 'm-phrase-text',
                        id: this.phrasesCounter,
                        parentModel: this.groupModel
                    },
                    {
                        key_words: u.phraseFormatter.getKeyWords(phrase),
                        minus_words: u.phraseFormatter.getMinusWords(phrase),
                        id: 0,
                        modelId: this.phrasesCounter
                    });

                this.groupModel.trigger('create-new-model', { model: model });

                this.groupModel.get('phrasesIds').push(this.phrasesCounter);
                this .phrasesCounter++;
            }, this);

            this.clearNewPhrases();

            return this;
        },

    /**
     * Инициализируем тулбар под инпутом для фраз
     * @returns {BEM}
     */
        initButtons: function() {
            if (this.buttons) return this;

            var actions = this.getActions(),
                name;

            this.buttons = {};

            this.findBlocksInside('link').forEach(function(elem) {
                name = this.getMod(elem.domElem, 'name');
                this.buttons[name] = elem;
                elem.on('click', actions[name] || $.noop, this)
            }, this);

            return this;
        },

    /**
     * Возвращает хэш с функциями, соответствующими кнопкам тулбара
     * @returns {{clear: Function, order: Function, split: Function}}
     */
        getActions: function() {
            return {
                clear: this.clearNewPhrases,
                order: this._sortPhrases,
                split: this._testPhrases
            }
        },

    /**
     * Событие изменения списка новых фраз
     * @param {Object} e
     * @param {Object} opt
     * @returns {BEM}
     */
        onNewPhrasesChange: function(e, opt) {
            var phrasesStr = this.groupModel.get('new_phrases').join(', ');

            (opt.source != this) && this.phrasesInput.val(phrasesStr);
            this.setMod('phrases-status', !phrasesStr ? 'empty' : '');

            this._updateCounter();

            return this;
        },

    /**
     * Преобразует массив фраз в строку фраз с разделителями
     * @param {Array } array
     * @param {Boolean} [newLine = true] Разделять фразы запятой и переносом строки
     * @return {String}
     * @private
     */
        _toStringList: function(array, newLine) {
            return array.join(typeof newLine == 'undefined' || newLine ? ',\n' : ',');
        },

    /**
     * Разбивает строку фраз в список
     * @param {String} phrases
     * @return {Array}
     * @private
     */
        _phrasesStrToArray: function(phrases) {
            if (phrases) {
                var result = [];

                phrases = $.trim(phrases);

                phrases.split(/\s*(?:,[\r\n\s]*|\r?\n[,\r\n\s]*)/).forEach(function(phrase) {
                    phrase = $.trim(phrase);

                    if (phrase !== '') {
                        result.push(phrase);
                    }
                });

                return $.unique(result);
            } else {
                return [];
            }
        },

     /**
     * Удаляет дубли и сортирует по алфавиту фразы в textarea
     * Не вызывает ajax запрос на получение саджестов
     */
        _sortPhrases: function() {
            this._isSorting = true;
            this.phrasesInput.val(
                this._toStringList(this._normalizePhrases([].concat(this.groupModel.get('new_phrases'))))
            );

            return this;
        },

    /**
     * Разбивает, сортирует фразы, удаляет дубли
     * @param {String|Array} phrases
     * @param {Boolean} [rmDoubles = true] Удалять дубли
     * @return {Array}
     * @private
     */
        _normalizePhrases: function(phrases, rmDoubles) {
            if (typeof phrases == 'string')
                phrases = this._phrasesStrToArray(phrases);

            if (typeof rmDoubles == 'undefined' || rmDoubles)
                phrases = $.unique(phrases);

            phrases = phrases.map(function(phrase) {
            //удаляем лишние пробелы
                return $.trim(phrase);
            }, this);

            return phrases.sort(this.params.sortMode == 'tr' ? bemBlocks.sortTr : undefined);
        },

    /**
     * Обновляет счетчик фраз и подсвечивает при превышении лимита
     * @returns {BEM}
     * @private
     */
        _updateCounter: function() {
            if (!this.elem('counter').length) return;

            var left = this.groupModel.getPhrasesLeft(),
                message = left >= 0 ?
                iget2('b-phrases-input', 'mozhno-dobavit-eshche-s1', 'Можно добавить еще {foo} фразу', {
                    foo: left,
                    count: left,
                    some: 'Можно добавить еще {foo} фразы',
                    many: 'Можно добавить еще {foo} фраз'
                }) :
                iget2('b-phrases-input', 'kolichestvo-fraz-prevysheno-na', 'Количество фраз превышено на {foo}', {
                    foo: -left
                });

            this.setMod(this.elem('counter').html(message), 'status', left < 0 ? 'overflow' : '');

            return this;
        },

    /**
     * Устанавливает модель, которую должен изменять инпут
     * @returns {BEM}
     */
        initModel: function() {
            this.groupModel = BEM.MODEL.getOrCreate(this.params.modelParams);

            this.newGroupModel = BEM.MODEL.getOne({
                name: 'm-phrases-group',
                id: 'new',
                parentModel: this.groupModel
            });

            this.groupModel
                .on('new_phrases', 'change', this.onNewPhrasesChange, this)
                .on('phrasesIds', 'change', this._updateCounter, this);

            BEM.MODEL.on({
                parentModel: this.groupModel,
                name: 'm-phrase-text'
            }, 'phrase', 'change', this._updateCounter, this);

            this._updateCounter();

            return this;
        },

    /**
     * Очистка полей новых фраз
     * Порождает вызов clearSuggestions
     */
        clearNewPhrases: function() {
            this.groupModel.set('new_phrases', []);
            this.phrasesInput.val('');
        }
    }, {
        live: function() {
            this.liveInitOnBlockInsideEvent('init', 'input');
        }
    });

})(jQuery);
