block('b-phrases-list-group')(
    def()(function() {
        var ctx = this.ctx,
            data = this.data,
            campaign = data.campaign,
            group = ctx.group,
            header = [],
            isCpmBanner = u.campaign.isCpm(campaign.mediaType),
            notEmptyConditions = [
                'phrases',
                'retargetings',
                u.consts('isSearchRetargetingEnabled') && 'searchRetargetings',
                'target_interests',
                'relevance_match'
            ].filter(function(type) {
                return Boolean(type) && group[type] && group[type].length > 0;
            });

        ctx.state === 'active' &&
        !data.view_only &&
        data.archived !== 'Yes' &&
        !(ctx.platform === 'search' && ctx.groupHasOnlyCpcVideoAndImageAds) &&
        notEmptyConditions.length > 1 &&
        // для cpm кампаний на автобюджетных стратегиях нет приоритета, поэтому редактируемых полей тоже нет
        !(isCpmBanner && campaign.strategy.is_autobudget) &&
        header.push({
            block: 'b-phrases-list-group',
            elem: 'input-block',
            elemMods: {
                state: 'common'
            },
            group: group,
            colsNum: ctx.colsNum,
            platform: ctx.platform,
            hasTrafficVolume: ctx.hasTrafficVolume,
            groupHasOnlyCpcVideoAndImageAds: ctx.groupHasOnlyCpcVideoAndImageAds
        });

        if (!ctx.phrases.length && ctx.state == 'active') {
            isCpmBanner ?
                header.push({ // При удалении «Ключевые фразы не заданы.» добавляется пустой tbody из-за чего нет бордера у таблицы в FF
                    tag: 'tr',
                    content: {
                        tag: 'td'
                    }
                }) :
                header.push({
                    block: 'b-phrases-list-group',
                    elem: 'empty-block',
                    colsNum: ctx.colsNum,
                    mix: [{
                        block: 'b-style-table',
                        elem: 'row'
                    }],
                    group: group,
                    mediaType: campaign.mediaType,
                    platform: ctx.platform
                });
        }

        return applyNext({
            header: header
        });
    }),

    addJs()(function() {
        return {
            state: this.ctx.state,
            platform: this.ctx.platform
        };
    }),

    content()(function() {
        var res = [],
            ctx = this.ctx,
            viewOnly = this.data.view_only,
            group = ctx.group,
            banner = ctx.banner,
            state = ctx.state,
            platform = ctx.platform,
            phrases = ctx.phrases || [],
            retargetings = ctx.retargetings || [],
            searchRetargetings = ctx.searchRetargetings || [],
            retargetingInterests = ctx.retargetingInterests || [],
            interests = ctx.interests || [],
            relevance_match = ctx.relevance_match || [],
            isAutobudget = this.data.campaign.strategy.is_autobudget,
            isDifferentPlaces = this.data.campaign.strategy_name == 'different_places',
            isSearchStop = isDifferentPlaces && this.data.campaign.strategy.search.name == 'stop',
            isCpmBanner = u.campaign.isCpm(this.data.campaign.mediaType),
            inactive = ctx.inactive,
            colsNum = ctx.colsNum,
            hasTrafficVolume = ctx.hasTrafficVolume,
            groupHasOnlyCpcVideoAndImageAds = ctx.groupHasOnlyCpcVideoAndImageAds,
            isFirstType;

        res.push({
            block: 'i-model-aggregator',
            content: phrases.concat(retargetings)
                .concat(searchRetargetings)
                .concat(retargetingInterests)
                .concat(interests)
                .concat(relevance_match).map(function(phrase) {
                    return {
                        block: 'i-model',
                        modelParams: {
                            // а в i-phrases-prices-helper дефолтной моделью ставится m-retargeting-bidable
                            name: {
                                retargeting: 'm-retargeting-bidable',
                                interest: 'm-interest-bidable',
                                relevance_match: 'm-relevance-match'
                            }[phrase.type] || 'm-phrase-bidable',
                            id: phrase.modelId,
                            parentId: group.dmParams.id,
                            parentName: group.dmParams.name,
                            data: phrase.type == 'retargeting' ?
                                applyCtx({
                                    block: 'm-retargeting-bidable',
                                    group: group,
                                    condition: phrase
                                }) : phrase.type === 'interest' ?
                                applyCtx({
                                    block: 'm-interest-bidable',
                                    group: group,
                                    interest: phrase
                                }) : phrase.type === 'relevance_match' ?
                                applyCtx({
                                    block: 'm-relevance-match',
                                    group: group,
                                    relevance_match: phrase
                                }) : applyCtx({
                                    block: 'm-phrase-bidable',
                                    group: group,
                                    phrase: phrase
                                })
                        }
                    };
                }, this)
        });

        this.header && res.push(this.header);

        isFirstType = true;

        ['phrases', 'retargetings', u.consts('isSearchRetargetingEnabled') && 'searchRetargetings', 'retargetingInterests', 'interests', 'relevance_match']
            .filter(Boolean)
            // Если понадобится рефакторинг таблицы ставок или еще один блок, показывающийся только на поиске,
            // то надо добавить новую группу фраз "search" (i-phrases-separate-into-groups, b-phrases-list)
            .forEach(function(type) {
                var items = ctx[type],
                    showSubHeaderRow = (state == 'active' ||
                        state == 'search' ||
                        state == 'context' ||
                        state == 'declined'),
                    needPlatformTitle = (isFirstType && ctx.state !== 'active'),
                    bemType = type;

                // заменяем землю на дефис
                if (type == 'relevance_match') {
                    bemType = 'relevance-match';
                }

                if (items && items.length) {

                    if (needPlatformTitle) {
                        // охватный продукт работает только в сетях, поэтому дополнительные пояснения не нужны
                        if (!isCpmBanner) {
                            res.push({
                                block: 'b-phrases-list-group',
                                elem: 'platform-title',
                                state: type === 'relevance_match' ? platform : state,
                                colsNum: colsNum
                            });
                        }
                    }

                    showSubHeaderRow && res.push({
                        block: 'b-phrases-list-group',
                        elem: 'input-block',
                        phrases: items,
                        elemMods: {
                            // из-за типа relevance_match
                            type: bemType,
                            state: state == 'active' || state == 'context' || state == 'search' && u.consts('isSearchRetargetingEnabled') ? state : 'inactive',
                            'is-first': isFirstType ? 'yes' : ''
                        },
                        group: group,
                        colsNum: colsNum,
                        type: type,
                        platform: platform,
                        hasTrafficVolume: hasTrafficVolume,
                        showEditPrice: ctx.showStat,
                        groupHasOnlyCpcVideoAndImageAds: groupHasOnlyCpcVideoAndImageAds,
                        enableEditPrices: !viewOnly &&
                            group.editable_price &&
                            // для cpm кампаний на автобюджетных стратегиях нет приоритета,
                            // поэтому редактируемых полей тоже нет
                            !(isCpmBanner && isAutobudget) &&
                            type !== 'searchRetargetings'
                    });

                    res.push({
                        elem: 'group-marker',
                        tag: 'tr',
                        elemMods: {
                            type: bemType
                        },
                        content: {
                            tag: 'td',
                            attrs: {
                                colspan: colsNum
                            }
                        }
                    });

                    items.forEach(function(phrase, i) {
                        res.push({
                            block: 'b-group-phrase',
                            mods: {
                                type: bemType,
                                first: i === 0 ? 'yes' : '',
                                'is-suspended': phrase.is_suspended ? 'yes' : ''
                            },
                            mix: [{
                                block: 'b-phrases-list-group',
                                elem: bemType,
                                elemMods: {
                                    inactive: inactive,
                                    platform: platform,
                                    'is-first-type': isFirstType ? 'yes' : ''
                                }
                            }],
                            isFirst: i == 0,
                            colsNum: colsNum,
                            hasTrafficVolume: ctx.hasTrafficVolume,
                            phrase: phrase,
                            phraseType: type,
                            readonly: group.archive === 'Yes',
                            group: group,
                            banner: banner,
                            state: state,
                            platform: platform,
                            isAutobudget: isAutobudget,
                            groupHasOnlyCpcVideoAndImageAds: groupHasOnlyCpcVideoAndImageAds
                        });
                    });

                    isFirstType = false;
                }

            });

        return res;
    })
);

block('b-phrases-list-group').elem('empty-block').content()(function() {
    var ctx = this.ctx;

    return [
        {
            block: 'b-phrases-list-group',
            elem: 'empty-block-text',
            attrs: {
                colspan: ctx.colsNum
            },
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: { first: 'yes' }
            }],
            mediaType: ctx.mediaType,
            platform: ctx.platform
        }
    ];
});

block('b-phrases-list-group').elem('input-block').elemMod('state', 'context')(
    addMix()([{
        block: 'b-style-table',
        elem: 'head',
        elemMods: { type: 'subhead' }
    }]),
    content()(function() {
        var res,
            type = this.ctx.type,
            campaign = this.data.campaign,
            platform = this.ctx.platform,
            isContext = platform == 'context',
            isCpmBanner = u.campaign.isCpm(campaign.mediaType),
            strategy = campaign.strategy,
            isAutobudget = strategy.is_autobudget,
            enableEditPrices = this.ctx.enableEditPrices,
            interestsDisabled = type == 'interests' && strategy.is_net_stop,
            retargetingsDisabled = type == 'retargetings' && strategy.is_net_stop,
            disabledHints = {
                interestPriority: iget2(
                    'b-phrases-list-group',
                    'prioritety-dlya-interesov-k',
                    'Приоритеты для интересов к мобильным приложениям нельзя установить, так как показы в сетях запрещены настройками стратегии'
                ),
                interestBid: iget2(
                    'b-phrases-list-group',
                    'stavki-dlya-interesov-k',
                    'Ставки для интересов к мобильным приложениям нельзя установить, так как показы в сетях запрещены настройками стратегии'
                ),
                retargetingPriority: iget2(
                    'b-phrases-list-group',
                    'prioritety-dlya-usloviy-podbora',
                    'Приоритеты для условий подбора аудитории нельзя установить, так как показы в сетях запрещены настройками стратегии'
                ),
                retargetingBid: iget2(
                    'b-phrases-list-group',
                    'stavki-dlya-usloviy-podbora',
                    'Ставки для условий подбора аудитории нельзя установить, так как показы в сетях запрещены настройками стратегии'
                )
            },
            disabledKey = interestsDisabled ? 'interest' : retargetingsDisabled ? 'retargeting' : '',
            disabledHintText = disabledHints[disabledKey + (isAutobudget ? 'Priority' : 'Bid')] || '',
            tail = [];

        // для cpm, если нет статистики, то нужно скрыть
        (!isCpmBanner || isCpmBanner && this.ctx.showEditPrice) && tail.push({
            elem: 'cell',
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: {
                    valign: 'middle',
                    align: 'center'
                }
            }],
            content: (enableEditPrices && this.ctx.platform != 'search' && type !== 'retargetingInterests') ?
                {
                    elem: 'edit-price',
                    contextOnly: 1,
                    group: this.ctx.group,
                    elemMods: {
                        platform: this.ctx.platform
                    },
                    platform: this.ctx.platform,
                    state: this.elemMods.state,
                    type: type,
                    disabled: interestsDisabled || retargetingsDisabled ? 'yes' : '',
                    disabledHintText: disabledHintText
                } :
                { elem: 'empty' }
        });

        // заглушка Охват (при отдельном размещении)
        isContext && !isCpmBanner && tail.push({
            block: 'b-phrases-list-group',
            elem: 'cell',
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: {
                    valign: 'middle',
                    align: 'center'
                }
            }],
            content: '&nbsp;'
        });

        // заглушка Объем трафика
        this.ctx.hasTrafficVolume && !isAutobudget && tail.push({
            block: 'b-phrases-list-group',
            elem: 'cell',
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: {
                    valign: 'middle',
                    align: 'center'
                }
            }],
            content: '&nbsp;'
        });

        res = [
            {
                elem: 'subheader-context',
                block: 'b-phrases-list-group',
                mix: [{
                    block: 'b-style-table',
                    elem: 'cell',
                    elemMods: { first: 'yes' }
                }],
                attrs: {
                    colspan: this.ctx.colsNum - tail.length
                },
                content: [
                    {
                        elem: 'subheader',
                        content: {
                            phrases: iget2('b-phrases-list-group', 'klyuchevye-frazy', 'Ключевые фразы'),
                            retargetings: iget2('b-phrases-list-group', 'usloviya-podbora-auditorii', 'Ретаргетинг и подбор аудитории'),
                            retargetingInterests: iget2('b-phrases-list-group', 'retargetings-interests-title', 'Интересы и соцдем'),
                            interests: iget2('b-phrases-list-group', 'interesy', 'Интересы')
                        }[type]
                    },
                    !!this.ctx.enableEditPrices && this.platform != 'search' && type !== 'retargetingInterests' && !isAutobudget && {
                        elem: 'edit-all-prices',
                        content: {
                            phrases: iget2('b-phrases-list-group', 'dlya-vseh-klyuchevyh-fraz', 'Для всех ключевых фраз'),
                            retargetings: iget2('b-phrases-list-group', 'dlya-vseh-usloviy', 'Для всех условий'),
                            retargetingInterests: iget2('b-phrases-list-group', 'retargetings-interests-title-all', 'Для всех условий'),
                            interests: iget2('b-phrases-list-group', 'dlya-vseh-interesov', 'Для всех интересов')
                        }[type] + ':'
                    }
                ]
            },
            tail
        ];

        return res;
    })
);

block('b-phrases-list-group').elem('input-block').elemMod('state', 'search')(
    addMix()([{
        block: 'b-style-table',
        elem: 'head',
        elemMods: { type: 'subhead' }
    }]),
    content()(function() {
        var res,
            type = this.ctx.type,
            campaign = this.data.campaign,
            isCpmBanner = u.campaign.isCpm(campaign.mediaType),
            strategy = campaign.strategy,
            isAutobudget = strategy.is_autobudget,
            enableEditPrices = this.ctx.enableEditPrices,
            tail = [];

        // для cpm, если нет статистики, то нужно скрыть
        (!isCpmBanner || isCpmBanner && this.ctx.showEditPrice) && tail.push({
            elem: 'cell',
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: {
                    valign: 'middle',
                    align: 'center'
                }
            }],
            content: enableEditPrices && !isAutobudget ?
                {
                    elem: 'edit-price',
                    contextOnly: 1,
                    group: this.ctx.group,
                    elemMods: {
                        platform: this.ctx.platform
                    },
                    platform: this.ctx.platform,
                    state: this.elemMods.state,
                    type: type
                } :
                { elem: 'empty' }
        });

        // заглушка Объем трафика
        this.ctx.hasTrafficVolume && !isAutobudget && tail.push({
            block: 'b-phrases-list-group',
            elem: 'cell',
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: {
                    valign: 'middle',
                    align: 'center'
                }
            }],
            content: '&nbsp;'
        });

        res = [
            {
                elem: 'subheader-context',
                block: 'b-phrases-list-group',
                mix: [{
                    block: 'b-style-table',
                    elem: 'cell',
                    elemMods: { first: 'yes' }
                }],
                attrs: {
                    colspan: this.ctx.colsNum - tail.length
                },
                content: [
                    {
                        elem: 'subheader',
                        content: {
                            searchRetargetings: iget2('b-phrases-list-group', 'usloviya-podbora-auditorii', 'Ретаргетинг и подбор аудитории'),
                        }[type]
                    },
                    !!this.ctx.enableEditPrices && !isAutobudget && {
                        elem: 'edit-all-prices',
                        content: {
                            searchRetargetings: iget2('b-phrases-list-group', 'dlya-vseh-usloviy', 'Для всех условий'),
                        }[type] + ':'
                    }
                ]
            },
            tail
        ];

        return res;
    })
);

block('b-phrases-list-group').elem('input-block').elemMod('state', 'inactive')(

    addMix()([{
        block: 'b-style-table',
        elem: 'head',
        elemMods: { type: 'subhead' }
    }]),

    content()(function() {
        return {
            elem: 'subheader-inactive',
            block: 'b-phrases-list-group',
            attrs: {
                colspan: this.ctx.colsNum
            },
            content: [
                {
                    block: 'button',
                    mods: {
                        arrow: 'down',
                        pseudo: 'yes'
                    },
                    mix: [{
                        block: 'b-phrases-list-group',
                        elem: 'inactive-toggle-button'
                    }],
                    content: [
                        {
                            block: 'b-phrases-list-group',
                            elem: 'inactive-toggler',
                            elemMods: {
                                mode: 'hide'
                            },
                            content: iget2('b-phrases-list-group', 'skryt-otklyuchennye-i-otklonyonnye', 'Скрыть отключенные и отклонённые')
                        },
                        {
                            block: 'b-phrases-list-group',
                            elem: 'inactive-toggler',
                            elemMods: {
                                mode: 'show'
                            },
                            content: iget2('b-phrases-list-group', 'pokazat-otklyuchennye-i-otklonyonnye', 'Показать отключенные и отклонённые')
                        }
                    ]
                }
            ],
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: { first: 'yes' }
            }]
        };
    })
);

block('b-phrases-list-group').elem('input-block').elemMod('state', 'common')(
    // строка для редактирования общей ставки для всего объявления
    addMix()([{
        block: 'b-style-table',
        elem: 'row',
        elemMods: {
            hlt: 'default',
            type: 'border'
        }
    }]),

    content()(function() {
        var ctx = this.ctx,
            campaign = this.data.campaign,
            isAutobudget = campaign.strategy.is_autobudget,
            res,
            tail = [],
            isContext = ctx.platform == 'context',
            isCpmBanner = u.campaign.isCpm(campaign.mediaType);

        if (isAutobudget) {
            return '';
        }

        tail.push({
            elem: 'cell',
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: {
                    valign: 'middle',
                    align: 'center'
                }
            }],
            content: (ctx.group.editable_price) ?
                {
                    elem: 'edit-price',
                    contextOnly: 1,
                    group: ctx.group,
                    elemMods: {
                        platform: ctx.platform
                    },
                    platform: ctx.platform,
                    state: this.elemMods.state,
                    type: 'common'
                } :
                { elem: 'empty' }
        });

        // заглушка Охват (при отдельном размещении)
        isContext && !isCpmBanner && tail.push({
            block: 'b-phrases-list-group',
            elem: 'cell',
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: {
                    valign: 'middle',
                    align: 'center'
                }
            }],
            content: '&nbsp;'
        });

        // заглушка Объем трафика
        this.ctx.hasTrafficVolume && !isAutobudget && tail.push({
            block: 'b-phrases-list-group',
            elem: 'cell',
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: {
                    valign: 'middle',
                    align: 'center'
                }
            }],
            content: '&nbsp;'
        });

        res = [
            {
                elem: 'subheader-context',
                block: 'b-phrases-list-group',
                mix: [{
                    block: 'b-style-table',
                    elem: 'cell',
                    elemMods: { first: 'yes' }
                }],
                attrs: {
                    colspan: ctx.colsNum - tail.length
                },
                content: [
                    !!ctx.group.editable_price && ctx.platform != 'search' && {
                        elem: 'edit-all-prices',
                        content: iget2('b-phrases-list-group', 'dlya-vsego-obyavleniya', 'Для всего объявления') + ':'
                    }
                ]
            },
            tail
        ];

        return res;
    })
);

block('b-phrases-list-group').elem('input-block').elemMod('state', 'active')(

    addMix()([
        {
            block: 'b-style-table',
            elem: 'head',
            elemMods: { type: 'subhead' }
        }
    ]),

    content()(function() {
        var res = [],
            ctx = this.ctx,
            campaign = this.data.campaign,
            isAutobudget = campaign.strategy.is_autobudget,
            type = this.ctx.type,
            platform = ctx.platform,
            isContext = platform == 'context',
            isCpmBanner = u.campaign.isCpm(campaign.mediaType),
            isContentPromotion = campaign.mediaType === 'content_promotion',
            enableEditPrices = this.ctx.enableEditPrices,
            tail = [];

        (!isCpmBanner || isCpmBanner && enableEditPrices) && tail.push({
            elem: 'cell',
            block: 'b-phrases-list-group',
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: {
                    valign: 'middle',
                    align: 'center'
                }
            }],
            content: enableEditPrices && !isAutobudget && type != 'relevance_match' ?
                {
                    block: 'b-phrases-list-group',
                    elem: 'edit-price',
                    elemMods: {
                        platform: platform
                    },
                    group: ctx.group,
                    platform: platform,
                    state: this.elemMods.state,
                    type: type
                } :
                ''
        });

        //заглушка для колонки "Охват"
        isContext && !isCpmBanner && tail.push({
            elem: 'cell',
            block: 'b-phrases-list-group',
            content: '&nbsp;',
            mix: [{
                block: 'b-style-table',
                elem: 'cell'
            }]
        });

        // заглушка Объем трафика
        this.ctx.hasTrafficVolume && !isAutobudget && !isContentPromotion && tail.push({
            block: 'b-phrases-list-group',
            elem: 'cell',
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: {
                    valign: 'middle',
                    align: 'center'
                }
            }],
            content: '&nbsp;'
        });

        res.push({
            elem: 'cell',
            block: 'b-phrases-list-group',
            attrs: {
                colspan: ctx.colsNum - tail.length
            },
            mix: [
                {
                    block: 'b-style-table',
                    elem: 'cell',
                    elemMods: { first: 'yes' }
                },
                {
                    block: 'b-phrases-list-group',
                    elem: 'subheader-active'
                }
            ],
            content: [
                {
                    elem: 'subheader',
                    content: {
                        phrases: iget2('b-phrases-list-group', 'klyuchevye-frazy', 'Ключевые фразы'),
                        retargetings: iget2('b-phrases-list-group', 'usloviya-podbora-auditorii', 'Ретаргетинг и подбор аудитории'),
                        interests: iget2('b-phrases-list-group', 'interesy', 'Интересы'),
                        relevance_match: iget2('b-phrases-list-group', 'avtotargeting', 'Автотаргетинг')
                    }[type]
                },
                !!enableEditPrices && type != 'relevance_match' && !isAutobudget && {
                    elem: 'edit-all-prices',
                    content: {
                        phrases: iget2('b-phrases-list-group', 'dlya-vseh-klyuchevyh-fraz', 'Для всех ключевых фраз'),
                        retargetings: iget2('b-phrases-list-group', 'dlya-vseh-usloviy', 'Для всех условий'),
                        searchRetargetings: iget2('b-phrases-list-group', 'dlya-vseh-usloviy', 'Для всех условий'),
                        interests: iget2('b-phrases-list-group', 'dlya-vseh-interesov', 'Для всех интересов')
                    }[type] + ':'
                }
            ]
        });

        res = res.concat(tail);

        return res;
    })
);

block('b-phrases-list-group').elem('edit-price').content()(function() {
    var ctx = this.ctx,
        group = ctx.group,
        type = ctx.type,
        campaign = this.data.campaign,
        campDMParams = {
            name: u.campaign.getCampaignModelName(campaign.mediaType),
            id: campaign.cid
        },
        platform = ctx.platform,
        isAutobudget = campaign.strategy.is_autobudget,
        elemMod = platform === 'search' ?
            'search' :
            platform === 'context' && !isAutobudget ?
                'context' :
                group.editable_price && isAutobudget ?
                    'autobudget' :
                    !ctx.contextOnly ? 'search' : 'context';

    if (elemMod === 'autobudget') {
        return '';
    }

    return {
        block: 'b-edit-phrase-price',
        mix: {
            block: 'b-phrases-list-group',
            elem: 'price-control',
            elemMods: {
                'obj-type': type
            }
        },
        mods: {
            'control-type': elemMod,
            multiedit: 'yes',
            'obj-type': type,
            disabled: this.ctx.disabled
        },
        campDMParams: campDMParams,
        group: group,
        editable: true,
        disabledHintText: this.ctx.disabledHintText
    };
});
