BEM.DOM.decl('b-phrases-list-sort', {
    onSetMod: {
        js: function() {
            this.fireSort = $.throttle(function(e, elem) {
                this.sortFunction(elem);
            }, 1000, this);
        }
    },

    /**
     * Получаем отдельные группы в списке фраз, внутри которых производится сортировка
     * @returns {Object}
     */
    getSortGroups: function() {
        return this.groups || (this.groups = this.findBlocksByInterfaceInside('i-sortable-interface'));
    },

    /**
     * Функция, сортирующая строки таблицы
     * @param {BEM} elem - объект инициализировавший сортировку
     */
    sortFunction: function(elem) {
        var name = this.getMod(elem, 'name').replace('-', '_'),
            reverse = this.getMod(elem, 'sort') == 'up' || !this.hasMod(elem, 'sort');

        this.delMod(this.elem('sort-link'), 'sort');

        this.getSortGroups().forEach(function(group) {
            group.sort(name, reverse);
        });

        this.setMod(elem, 'sort', reverse ? 'down' : 'up');

        return this;
    }
}, {
    live: function() {
        this.liveBindTo('sort-link', 'click', function(e) {
            // для DIRECT-39382
            if (!$(e.target).closest(this.buildSelector('help')).length) {
                this.fireSort(e, e.data.domElem);
            }
        });
    }
});
