block('b-phrases-list')(
    def()(function() {
        var data = this.data,
            interestTree = data.interest_categories &&
                u['interests-targeting'].transformServerData(data.interest_categories),
            group = this.ctx.group,
            pid = group.pid,
            contentCategories = data.adgroup_additional_targetings[pid],
            allRetargetigsConditions = data.all_retargeting_conditions,
            platform = this.mods.platform,
            campaign = data.campaign,
            isMcbanner = campaign.mediaType === 'mcbanner',
            isCpmBanner = u.campaign.isCpm(campaign.mediaType),
            isAutobudget = data.campaign.strategy.is_autobudget,
            isOutdoor = group.cpm_banners_type === 'cpm_outdoor',
            isIndoor = group.cpm_banners_type === 'cpm_indoor',
            isCPMVideo = group.cpm_banners_type === 'cpm_video',
            isCPMBanner = group.cpm_banners_type === 'cpm_banner',
            showContentCategories = campaign.mediaType === 'text' || isCPMVideo || isCPMBanner,
            hasCategories = contentCategories && contentCategories.length,
            groupHasOnlyCpcVideoAndImageAds = u.imageAd.groupHasOnlyCpcVideoAndImageAds(group.group_banners_types),
            hasTrafficVolume = !isMcbanner && platform !== 'context' && !groupHasOnlyCpcVideoAndImageAds && u['traffic-volume'].hasTrafficVolume(this.ctx.group),
            contents = [{
                block: 'b-phrases-list',
                elem: 'header',
                mix: [{
                    block: 'b-style-table',
                    elem: 'head'
                }],
                group: group,
                platform: platform,
                hasTrafficVolume: hasTrafficVolume
            }],
            colsNum,
            campaignIsArchived = data.archived === 'Yes',
            groupNames;

        //data.OrderID - для страницы просмотра кампании, data.campaign.OrderID - для второго шага редактирования
        data.showStat = (data.OrderID !== '0' && data.campaign.OrderID !== '0' && !campaignIsArchived);

        if (data.showStat) {
            colsNum = (platform === 'context') ?
                //на контексте статистика только по кликам (или по показам в случае кампании с типом cpm_banner и cpm_deals)
                5 :
                //на поиске четыре столбца со статистикой (но может быть и 3: DIRECT-79072)
                (hasTrafficVolume && u.consts('enableWCTR') ? 8 : 7);
        } else {
            //фраза + заголовок (два столбца) + ставка
            colsNum = 4;
        }

        // на контексте(если это не кампании cpm_banner cpm_deals) есть дополнительный столбец охват
        if (platform === 'context' && !isCpmBanner) colsNum++;

        // столбец "текущий объем трафика"
        if (hasTrafficVolume && !isAutobudget) colsNum++;

        // если в группе только баннеры с графическими объявлениями
        if (groupHasOnlyCpcVideoAndImageAds && platform !== 'context') {
            // не показываем столбцы 'Цены за позиции' (-2)
            // показываем сообщение о показах только на тематических площадках (+1)
            colsNum--;
        }

        if (isCpmBanner) {
            // для cpm кампаний не показываем столбцы 'Цены за позиции'
            colsNum -= 2;

            // если есть статистика для не (outdoor || indoor) - добавляется столбец CTR и Клики
            if (data.showStat && (!isOutdoor && !isIndoor)) {
                colsNum += 2;
            }
        }

        if (isAutobudget) {
            colsNum -= 1;
        }

        if (u.consts('isSearchRetargetingEnabled')) {
            groupNames = [
                'active',
                platform !== 'context' && !+data.campaign.strategy2.is_search_stopped && 'search',
                platform !== 'search' && !+data.campaign.strategy2.is_net_stopped && 'context',
                'low_ctr', 'declined'
            ].filter(Boolean);
        } else {
            groupNames = data.campaign.strategy_name == 'different_places' && platform == 'search' ?
                ['active', 'low_ctr', 'declined'] :
                ['active', 'context', 'low_ctr', 'declined'];
        }

        groupNames.forEach(function(name) {
            var phrases = group.sorted.phrases[name],
                retargetings = group.sorted.retargetings[name],
                searchRetargetings = u.consts('isSearchRetargetingEnabled') ? group.sorted.searchRetargetings[name] : [],
                interests = group.sorted.interests[name],
                retargetingInterests = group.sorted.retargetingInterests[name],
                relevanceMatch = group.sorted.relevance_match[name],
                searchRetargetingsLength = platform !== 'context' ? searchRetargetings.length : 0,
                size = phrases.length + retargetings.length + searchRetargetingsLength + retargetingInterests.length + interests.length +
                    (platform != 'context' ? relevanceMatch.length : 0),
                inactive = name == 'low_ctr' || name == 'declined' ? 'yes' : 'no',
                state = name.replace('_', '-');

            // если в группе выбраны категории, а в профиле пользователей вся аудитория,
            // то для медийных групп не отрисовываем блок "Профиль пользователей"
            if ((isCPMVideo || isCPMBanner) && hasCategories) {
                var retCondId = retargetingInterests && retargetingInterests[0] && retargetingInterests[0].ret_cond_id,
                    retData = allRetargetigsConditions && retCondId && allRetargetigsConditions[retCondId],
                    isInterests = retData && u['retargeting'].isConditionType(retData, 'interests'),
                    condition = retData && retData.condition || [];

                if (isInterests && !condition.length) {
                    return;
                }
            }

            (size > 0 || name == 'active') && contents.push({
                block: 'b-phrases-list-group',
                mods: {
                    state: state,
                    inactive: inactive,
                    adgroupId: group.adgroup_id,
                    empty: size == 0 ? 'yes' : 'no',
                    platform: platform,
                    'hide-inactive': 'yes'
                },
                interestTree: interestTree,
                showStat: data.showStat,
                inactive: inactive,
                state: state,
                phrases: phrases,
                colsNum: colsNum,
                hasTrafficVolume: hasTrafficVolume,
                retargetings: retargetings,
                searchRetargetings: searchRetargetings,
                retargetingInterests: retargetingInterests,
                interests: interests,
                relevance_match: relevanceMatch,
                group: group,
                platform: platform,
                autobudget: group.autobudget,
                groupHasOnlyCpcVideoAndImageAds: groupHasOnlyCpcVideoAndImageAds
            });
        });

        if (showContentCategories && hasCategories) {
            contents.push({
                block: 'b-content-categories-list-group',
                contentCategories: contentCategories,
                colsNum: colsNum
            });
        }

        this.ctx.mods = this.extend(this.ctx.mods || {}, {
            'group-id': group.adgroup_id
        });

        return applyNext({
            contents: contents,
            showStat: data.showStat,
            colsNum: colsNum,
            groupHasOnlyCpcVideoAndImageAds: groupHasOnlyCpcVideoAndImageAds,
            autobudetRMP: campaign.mediaType === 'mobile_content' && isAutobudget,
            campaignIsArchived: campaignIsArchived
        });
    }),

    addJs()(true),

    content()(function() {
        return [
            this.data.campaign.platform == 'both' && {
                elem: 'title',
                content: this.mods.platform == 'search' ?
                    iget2('b-phrases-list', 'na-poiske', 'На поиске') :
                    iget2('b-phrases-list', 'v-setyah', 'В сетях')
            },
            {
                block: 'b-phrases-list',
                elem: 'paranja'
            },
            {
                block: 'b-phrases-list',
                elem: 'table',
                mix: [
                    {
                        block: 'b-phrases-list-sort',
                        js: true
                    },
                    {
                        block: 'b-style-table',
                        mods: {
                            theme: 'bordered'
                        }
                    },
                    this.data.campaign.platform == 'both' && {
                        block: 'b-phrases-list',
                        elem: '3-em-margin'
                    }
                ],
                content: this.contents
            }
        ];
    })
);

block('b-phrases-list').elem('paranja').content()({
    block: 'spin',
    js: true,
    mods: {
        progress: 'yes',
        theme: 'gray-48'
    },
    mix: {
        block: 'b-phrases-list',
        elem: 'paranja-spin'
    }
});

block('b-phrases-list').elem('header').content()(function() {
    var data = this.data,
        campaign = data.campaign,
        isContext = this.ctx.platform == 'context',
        isAutobudget = data.campaign.strategy.is_autobudget,
        isOutdoor = this.ctx.group.cpm_banners_type === 'cpm_outdoor',
        isIndoor = this.ctx.group.cpm_banners_type === 'cpm_indoor',
        isContentPromotion = campaign.mediaType === 'content_promotion',
        header,
        formatedCurrency = u.currencies.getName(data.campaign.currency),
        groupMultiplierStats = this.ctx.group.group_multiplier_stats || {},
        adjustmentsLowerBound = groupMultiplierStats.adjustments_lower_bound,
        adjustmentsUpperBound = groupMultiplierStats.adjustments_upper_bound,
        // для архивных кампаний не показываем сообщение о корректировках ставок (DIRECT-62540)
        hasAdjustmentFork = !this.campaignIsArchived &&
            (typeof adjustmentsUpperBound === 'number' || typeof adjustmentsLowerBound === 'number'),
        emptyCols = [],
        groupHasOnlyCpcVideoAndImageAds = this.groupHasOnlyCpcVideoAndImageAds,
        isMcbanner = campaign.mediaType === 'mcbanner',
        isCpmBanner = u.campaign.isCpm(campaign.mediaType),
        bidsText = {
            /* eslint-disable quote-props */
            'context': [
                { elem: 'bids-header', content: iget2('b-phrases-list', 'ohvat-auditorii', 'Охват<br/>аудитории') },
                { elem: 'bids-header', content: iget2('b-phrases-list', 'context-click-price', 'Цена клика<br/>в сетях, {cur}', { cur: formatedCurrency }) }
            ],
            'no-context': [
                {
                    elem: 'bids-header',
                    content: [
                        {
                            block: 'b-help-link',
                            mix: { block: 'b-phrases-list', elem: 'bids-header-help' },
                            mods: { type: 'modal' },
                            url: u.getHelpUrl('positions')
                        },
                        iget2('b-phrases-list', 'traffic-volume', 'Объём<br/>трафика')
                    ]
                },
                { elem: 'bids-header', content: iget2('b-phrases-list', 'rate-forecast', 'Прогноз<br/>ставки, {cur}', { cur: formatedCurrency }) },
                { elem: 'bids-header', content: iget2('b-phrases-list', 'used-price', 'Спис.<br/>цена, {cur}', { cur: formatedCurrency }) }
            ],
            'no-context+mcbanner': {
                elem: 'bids-header',
                content: [
                    { elem: 'bids-header', content: iget2('b-phrases-list', 'rate-forecast', 'Прогноз<br/>ставки, {cur}', { cur: formatedCurrency }) },
                    { elem: 'bids-header', content: iget2('b-phrases-list', 'used-price', 'Спис.<br/>цена, {cur}', { cur: formatedCurrency }) }
                ]
            },
            'content-promotion': {
                elem: 'bids-header',
                content: null
            }
            /* eslint-enable quote-props */
        },
        bidsKey = isContentPromotion ?
            'content-promotion' :
            isContext ?
                'context' :
                isMcbanner ?
                    'no-context+mcbanner' :
                    'no-context',
        i;

    header = [
        {
            block: 'b-phrases-list',
            elem: 'header-cell',
            autobudget: this.data.autobudget,
            elemMods: {
                content: 'phrase'
            },
            mix: [{
                block: 'b-style-table',
                elem: 'cell',
                elemMods: { first: 'yes' }
            }],
            content: {
                block: 'b-phrases-list-sort',
                elem: 'sort-link',
                elemMods: {
                    name: 'phrase',
                    sort: 'up'
                },
                title: iget2('b-phrases-list', 'usloviya-pokaza', 'Условия показа')
            }
        },

        groupHasOnlyCpcVideoAndImageAds && !isContext && {
            block: 'b-phrases-list',
            elem: 'header-cell',
            mix: [{
                block: 'b-style-table',
                elem: 'cell'
            }],
            content: campaign.mediaType === 'text' && u.consts('rights').allowedCpcVideoBanners ?
                [
                    {
                        elem: 'header-hint',
                        content: iget2('b-phrases-list', 'image-ads-and-cpc-video-are-shown-only-on-context', 'Графические и видео объявления показываются только в сетях')
                    },
                    {
                        block: 'b-help-link',
                        mods: { align: 'top', type: 'modal' },
                        mix: { block: 'b-phrases-list-sort', elem: 'help' },
                        // cyn@TODO: заменить id тултипа на новый https://st.yandex-team.ru/DIRECT-83762
                        url: u.getCommonHelpUrl('/direct-tooltips/image-ads-displayed.xml')
                    }
                ] :
                [
                    {
                        elem: 'header-hint',
                        content: iget2('b-phrases-list', 'graficheskie-obyavleniya-pokazyvayutsya-tolko', 'Графические объявления показываются только в сетях')
                    },
                    {
                        block: 'b-help-link',
                        mods: { align: 'top', type: 'modal' },
                        mix: { block: 'b-phrases-list-sort', elem: 'help' },
                        url: u.getCommonHelpUrl('/direct-tooltips/image-ads-displayed.xml')
                    }
                ]
        }
    ];

    if (this.showStat) {
        var statFields;

        if (isContext) {
            if (isCpmBanner) {
                // Если (outdoor || indoor) – столбики "Клики" и "CTR" не нужны
                statFields = isOutdoor || isIndoor ? {
                    'ctx-shows': iget2('b-phrases-list', 'pokazy', 'Показы')
                } : {
                    'ctx-shows': iget2('b-phrases-list', 'pokazy', 'Показы'),
                    'ctx-clicks': iget2('b-phrases-list', 'kliki', 'Клики'),
                    'ctx-ctr': iget2('b-phrases-list', 'ctr', 'CTR')
                };
            } else {
                statFields = {
                    'ctx-clicks': iget2('b-phrases-list', 'kliki', 'Клики')
                };
            }
        } else {

            if (this.ctx.hasTrafficVolume && u.consts('enableWCTR')) {
                statFields = {
                    'effective-ctr': iget2('b-phrases-list', 'wctr', 'wCTR'),
                    shows: iget2('b-phrases-list', 'pokazy', 'Показы'),
                    clicks: iget2('b-phrases-list', 'kliki', 'Клики'),
                    ctr: iget2('b-phrases-list', 'ctr', 'CTR')
                };
            } else {
                statFields = {
                    shows: iget2('b-phrases-list', 'pokazy', 'Показы'),
                    clicks: iget2('b-phrases-list', 'kliki', 'Клики'),
                    ctr: iget2('b-phrases-list', 'ctr', 'CTR')
                };

            }
        }

        Object.keys(statFields).forEach(function(key) {
            header.push({
                block: 'b-phrases-list',
                mix: [{
                    block: 'b-style-table',
                    elem: 'cell'
                }],
                elem: 'header-cell',
                autobudget: isAutobudget,
                elemMods: {
                    content: 'stat'
                },
                content: {
                    block: 'b-phrases-list-sort',
                    elemMods: {
                        name: key
                    },
                    elem: 'sort-link',
                    title: statFields[key]
                }
            });
        });
    }

    (!groupHasOnlyCpcVideoAndImageAds || isContext) && !isCpmBanner && header.push({
        block: 'b-phrases-list',
        mix: [{
            block: 'b-style-table',
            elem: 'cell'
        }],
        elem: 'header-cell',
        autobudget: data.autobudget,
        attrs: {
            colspan: '2'
        },
        elemMods: {
            content: 'position',
            'no-border': isMcbanner && !data.showStat ? 'yes' : ''
        },
        content: bidsText[bidsKey]
    });

    // В cpm при автобюджете колонку не показываем
    !isAutobudget && header.push({
        block: 'b-phrases-list',
        mix: [{
            block: 'b-style-table',
            elem: 'cell',
            elemMods: { align: isContentPromotion ? 'right' : 'center' }
        }],
        attrs: isContentPromotion && {
            colspan: '2'
        },
        elem: 'header-cell',
        elemMods: {
            content: 'price'
        },
        content: (function() {
            if (isCpmBanner) {
                return iget2('b-phrases-list', 'bid-for-thousand-shows-header', 'Ставка за тыс. показов, {foo}', {
                    foo: formatedCurrency
                });
            } else {
                return iget2('b-phrases-list', 'bid-header', 'Ставка, {foo}', {
                    foo: formatedCurrency
                })
            }
        })()
    });

    isContext && !isCpmBanner && header.push({
        block: 'b-phrases-list',
        mix: [{
            block: 'b-style-table',
            elem: 'cell',
            elemMods: { align: 'center' }
        }],
        elem: 'header-cell',
        elemMods: {
            content: 'coverage'
        },
        content: [
            iget2('b-phrases-list', 'ohvat', 'Охват'),
            {
                block: 'b-help-link',
                mods: {
                    align: 'top',
                    type: 'modal'
                },
                url: u.getHelpUrl('audience-coverage-yan')
            }
        ]
    });

    this.ctx.hasTrafficVolume && !isAutobudget && !isContentPromotion && header.push({
        block: 'b-phrases-list',
        elem: 'header-cell',
        elemMods: {
            content: 'qs'
        },
        mix: [{
            block: 'b-style-table',
            elem: 'cell',
            elemMods: { align: 'right' }
        }],
        content: [
            {
                block: 'b-help-link',
                mix: [
                    {
                        block: 'b-hintable-popup',
                        js: {
                            hint: iget2('b-phrases-list', 'traffic-forecast-hint', 'Трафик прогнозируется по данным торгов в текущий момент<br/>без учёта корректировки ставок.'),
                            directions: ['bottom']
                        }
                    },
                    {
                        block: 'b-phrases-list',
                        elem: 'bids-header-help'
                    }
                ]
            },
            iget2('b-phrases-list', 'traffic-forecast', 'Прогноз<br/>трафика')
        ]
    });

        // DIRECT-43188
    if (hasAdjustmentFork) {
        for (i = 1; i < this.colsNum; i++) {
            emptyCols.push({
                block: 'b-dynamic-conditions-table',
                mix: [
                    {
                        block: 'b-style-table',
                        elem: 'cell'
                    },
                    {
                        block: 'b-phrases-list',
                        elem: 'header-cell'
                    }
                ],
                elem: 'header-cell'
            });
        }
    }

    return [
        {
            block: 'b-phrases-list',
            elem: 'header-row',
            mix: [{
                block: 'b-style-table',
                elem: 'row',
                elemMods: {
                    position: 'top'
                }
            }],
            content: header
        },
        hasAdjustmentFork && {
            block: 'b-phrases-list',
            elem: 'header-row',
            mix: [{
                block: 'b-style-table',
                elem: 'row',
                elemMods: {
                    position: 'bottom'
                }
            }],
            content: [
                {
                    block: 'b-phrases-list',
                    mix: {
                        block: 'b-style-table',
                        elem: 'cell'
                    },
                    elem: 'header-cell',
                    content: {
                        block: 'b-adjustment-rates-fork',
                        lowerBound: adjustmentsLowerBound,
                        upperBound: adjustmentsUpperBound
                    }
                },
                emptyCols
            ]
        }
    ];
});
