(function() {
    var SUGGESTIONS_ON_PAGE = 10,
        REQUEST_TIMEOUT = 1000;

    BEM.DOM.decl('b-phrases-suggestions', {
        onSetMod: {
            js: function() {
                this.spin = this.findBlockInside('spin');

                this.toggler = this.findBlockOn('toggler', 'button')
                    .on('click', function() {
                        this.trigger('hide');
                    }, this);

                this.loadSuggestionsDebounce = $.debounce(this.loadSuggestions, REQUEST_TIMEOUT, this);
                this.loadUrlSuggestionsDebounce = $.debounce(this.loadUrlSuggestions, REQUEST_TIMEOUT, this);

                this.initToolbar();

                this.initModel();
            }
        },

        /**
         * Информация о загруженных саджестах
         */
        _suggestions: null,

        /**
         * Получение информации о загруженных саджестах
         * @returns {null|{haveAfter: boolean, phrases: Array, page: number}}
         * @private
         */
        _getSuggestions: function() {
            return this._suggestions || (this._suggestions = {
                haveAfter: false,
                phrases: [], //подсказки текущей "страницы", для быстрой вставки
                page: 0 //"страница" (итерация) подсказок
            });
        },

        /**
         * Инициализируем псевдоссылки
         */
        initToolbar: function() {
            var actions = this.getActions(),
                name;

            this.buttons = {};

            this.findBlocksInside('link').forEach(function(elem) {
                name = this.getMod(elem.domElem, 'name');
                this.buttons[name] = elem;
                elem.on('click', actions[name] || $.noop, this);
            }, this)
        },

        /**
         * Инстанс блока i-request_type_ajax
         */
        _request: null,

        /**
         * Получаем инстанс блока i-request_type_ajax для создания запросов
         * @returns {null|BEM}
         * @private
         */
        _getRequest: function() {
            return this._request || (this._request = BEM.create('i-request_type_ajax', {
                type: 'post',
                url: '/registered/main.pl',
                dataType: 'json',
                callbackCtx: this
            }));
        },

        model: null,

        /**
         * Установка модели баннера
         */
        initModel: function() {
            var bannerModelName = 'm-banner';

            this.model = BEM.MODEL.getOne(this.params.modelParams);

            this.model
                .on('new_phrases', 'change', function(e, data) {
                    if (data.ignore) return;

                    //@heliarian при вводе новых слов начинаем подгружать подсказки заново с 1-й страницы
                    //подробнее - DIRECT-46064
                    this._suggestions.page = 1;

                    this.loadSuggestionsDebounce();
                }, this);

            BEM.MODEL.on(
                { parentModel: this.model, name: 'm-phrase-text' },
                'phrase',
                'change',
                this.loadSuggestionsDebounce,
                this);

            BEM.MODEL.get({ name: bannerModelName, parentModel: this.model }).forEach(function(bannerModel) {
                bannerModel.get('href_model').on('href', 'change', this.loadUrlSuggestionsDebounce, this);
            }, this);

            this.loadSuggestions();
        },

        getActions: function() {
            return $.extend(this.__base(this, arguments), {
                //кнопка в начало
                prev: function() {
                    this._getSuggestions().page = 1;
                    this.loadSuggestionsDebounce();
                },
                //кнопка "еще"
                next: function() {
                    this ._getSuggestions().page++;
                    this.loadSuggestionsDebounce();
                },
                'insert-all': function() {
                    /*  Добавляем все подсказки текущей итерации в новые фразы
                     *  и, если есть следующая итерация - получаем ее */
                    this.appendNewPhrases(this._getSuggestions().phrases);
                    this ._getSuggestions().page++;
                    this._getSuggestions().haveAfter && this.loadSuggestionsDebounce();
                }
            });
        },

        appendNewPhrases: function(phrases) {
            this.model.set('new_phrases', this.model.get('new_phrases').concat(phrases), { source: this });
        },

        /**
         * Рендерит список подсказки
         * @param {Array} list Список полученных подсказок
         * @private
         */
        _renderSuggestions: function(list) {
            var suggestionsItems = list.map(function(word) {
                return {
                    block: 'b-phrases-suggestion',
                    modelParams: this.params.modelParams,
                    word: word
                }
            }, this);

            BEM.DOM.update(this.elem('list'), BEMHTML.apply(suggestionsItems), function() {
                this.setMod('status', 'loaded');
            }, this);
        },

        /**
         * Обработка новых саджестов
         * @param {Object} data
         * @private
         */
        _processNewSuggestions: function(data) {
            this.spin.delMod('progress');

            if (!data || !data.phrases || !data.phrases.length) {
                this.setMod('status', 'no-suggestions');
                this._getSuggestions().haveAfter = false;
                this._getSuggestions().page = 0;
                this._getSuggestions().phrases = [];
            } else {
                this._getSuggestions().haveAfter = !!data.is_something_after;
            }

            //сохраняем данные о наличии доп. данных и скрываем/отображаем кнопки навигации для них
            this.buttons['prev'].setMod(
                'hidden',
                this._getSuggestions().page != 1 && !this._getSuggestions().haveAfter ?
                    'no' :
                    'yes'
            );
            this.buttons['next'].setMod('hidden', this._getSuggestions().haveAfter ? 'no' : 'yes');

            data && data.phrases && data.phrases.length &&
                this._renderSuggestions(this._getSuggestions().phrases = data.phrases);
        },

        /**
         * Очищает список подсказок
         */
        clearSuggestions: function() {
            this.elem('list').html('');
        },

        /**
         * Получаем массив со всеми фразами (новые + старые)
         * @returns {Array}
         */
        getAllPhrases: function() {
            return [].concat(this.model.get('new_phrases'), this.model.getPhrases());
        },

        /**
         * Загружает подсказки
         */
        loadSuggestions: function() {
            var phrases = this.getAllPhrases();

            this._getSuggestions().page = this._getSuggestions().page || 1;

            this.elem('list').html('');

            if (phrases) {
                this.spin.setMod('progress', 'yes');
                this.setMod('status', 'loading');
                var a = this._getSuggestions().page - 1;

                //обработчик единый
                this._getRequest().get(
                    {
                        srcPhrases: phrases.join(', '),
                        iteration: a,
                        cmd: 'ajaxGetSuggestion',
                        brief: 'yes',
                        n: SUGGESTIONS_ON_PAGE
                    },
                    this._processNewSuggestions,
                    this._processNewSuggestions);

            } else {
                this.setMod('status', 'no-phrases');
            }

        },

        /**
         *   Загрузка подсказок по url-у
         */
        loadUrlSuggestions: function() {
            var retargetings = this.model.get('retargetingsIds'),
                interests = this.model.get('interestsIds');

            if (this.model.get('new_phrases').length ||
                this.model.getPhrasesLength() ||
                retargetings && retargetings.length ||
                interests && interests.length) return;

            var firstBanner = BEM.MODEL.getOrCreate({
                name: 'm-banner',
                id: this.model.get('bannersIds')[0]
            });

            this._getRequest().get({
                cmd: 'ajaxGetUrlPhrases',
                detail: 0,
                url: firstBanner.get('href_model').get('href'),
                url_protocol: firstBanner.get('href_model').get('url_protocol')
            },
                this._processNewSuggestions,
                this._processNewSuggestions);
        },

        /**
         * Событие изменения списка новых фраз
         * @param {Event} e
         * @param {Object} data Дополнительные данные
         * @private
         */
        _onNewPhrasesChange: function(e, data) {
            this.__base(this, arguments);

            this.getMod('suggestions') == 'on' && this.loadSuggestionsDebounce();

            return this;
        }
    }, {
        live: true
    });

})();
