BEM.DOM.decl({ block: 'b-pic-selector', modName: 'multi', modVal: 'yes', implements: 'i-outboard-controls' }, {

    onSetMod: {
        js: function() {
            this._mediaType = this.params.mediaType;

            this._groupModel = BEM.MODEL.create(u.campaign.getGroupModelName(this._mediaType), {
                adgroup_type: this._mediaType,
                cid: this.params.cid
            });

            this._bannerModel = BEM.MODEL.create({
                name: u.campaign.getBannerModelName(this._mediaType),
                parentModel: this._groupModel
            });

            this.__base.apply(this, arguments);

            BEM.MODEL.on(
                { name: 'm-banner-pic', id: '*', parentName: this._bannerModel.name, parentId: '*' },
                'update clear',
                function() {
                    this._updateBannerPic();
                }, this);

            this
                .on('save-action', function() {
                    this.provideData();
                }, this)
                .on('cancel-action', function() {
                    this.declineChange();
                }, this);

            this.prepareToShow({
                modelParams: {
                    id: this._bannerModel.id,
                    name: this._bannerModel.name,
                    parentId: this._groupModel.id,
                    parentName: this._groupModel.name
                }
            });
        },

        editor: function(modName, modVal) {
            var isInit = modVal === 'init';
            this._setButtonsDisabledState({ back: isInit, save: isInit });

            this.__base.apply(this, arguments);
        }
    },

    /**
     * Вызов нажатия кнопки извне
     * Используется на мультиредактировании, так как там у блока выбора картинки спрятан подвал
     * @param {String} type
     */
    triggerButton: function(type) {
        this._doAction(type);
    }

}, {

    live: true

});
