BEM.DOM.decl({
    block: 'b-pic-selector',
    modName: 'type',
    modVal: 'mobile-content',
    implements: 'i-outboard-controls'
}, {

    /**
     * Сбрасывает отображение превью баннера
     * @param {String} [url]
     * @protected
     * @override
     */
    _resetBannerPreview: function(url) {
        var bannerPreviewModel = this._getBannerPreview().getViewModel();

        // todo: resetBannerPreview не должен устанавливать url изображения (DIRECT-54985)
        // эту логику надо перенести в showPreview
        // (скорее всего это было сделано, так как в _showPreview логика определения как перерисовывать картинку завязана
        // на наличие элемента изображения и если использовать функцию showPreview, то при загрузке изображения
        // в первый раз превью перересуется некорректно)
        if (url) {
            bannerPreviewModel.update({
                imageHeight: this._picHeight169,
                imageWidth: this._picWidth169,
                previewUrl: url || ''
            });
        } else {
            bannerPreviewModel.set('previewUrl', '');
        }
    },

    /**
     * Назначение URL адреса на превью по идентификатору изображения
     * @param {String} mdsGroupId номер группы в Аватарнице
     * @param {String} id строковый идентификатор изображения
     * @param {Boolean} [isWide] указывает на необходимость построить URL большой картинки
     * @returns {BEM.DOM}
     * @protected
     * @override
     */
    _setThumb: function(mdsGroupId, id, isWide) {
        this._resetBannerPreview(this._makeThumbURL(mdsGroupId, id, isWide));

        return this;
    },

    /**
     * Показывает превью в блоке b-banner-prewview
     * @returns {Object}
     * @protected
     * @override
     */
    _showPreview: function() {
        var preview,
            yapImage,
            // todo: DIRECT-54985 - определять пропорции изображения более корректным способом (должны быть реальные размеры превью)
            previewHeight = this._picHeight169,
            previewWidth = this._picWidth169,
            previewUrl = this._getBannerImageCrop().getCroppedPreviewDataURL({
                height: previewHeight,
                width: previewWidth
            });

        if (previewUrl) {
            preview = this._getBannerPreview();
            yapImage = preview.domElem.find('.yap-image');

            // при обрезке изображения слишком дорого перерисовывать всё превью
            // партнёрским кодом, поэтому вынуждено меняем url напрямую
            // с учётом того, что элемента может не быть: тогда выполняем дорогой сценарий
            // перерисовки всего превью
            yapImage.length ?
                yapImage.attr({ src: previewUrl }) :
                preview.getViewModel().update({
                    imageHeight: previewHeight,
                    imageWidth: previewWidth,
                    previewUrl: previewUrl
                });
        }

        return this;
    },

    /**
     * Возвращает блок превью баннера
     * @returns {BEM.DOM}
     * @protected
     * @override
     */
    _getBannerPreview: function() {
        return this._bannerPreview ||
            (this._bannerPreview = this.findBlockInside(this.elem('preview'), 'b-banner-preview2'));
    },

    /**
     * Обновляет превью баннера
     * @param {Object} modelParams параметры модели баннера
     * @param {String} modelParams.id id инстанса модели
     * @param {String} modelParams.name имя модели
     * @param {String} modelParams.parentId id инстанса родительской модели
     * @param {String} modelParams.parentName имя родительской модели
     * @protected
     * @override
     */
    _updateBannerPreview: function(modelParams) {
        var bannerModel = BEM.MODEL.getOrCreate(modelParams),
            groupModel = bannerModel.getGroup();

        this._bannerPreview = null;

        BEM.DOM.update(this.elem('preview'), BEMHTML.apply({
            block: 'b-banner-preview2',
            mods: { type: 'mobile-content', view: 'mobile-content-partner-poster' },
            modelsParams: {
                dmsIds: {
                    bannerId: bannerModel.id,
                    groupId: groupModel.id,
                    mobileContentId: groupModel.get('mobile_content').id,
                    phraseId: (u.pickRandom(groupModel.get('phrases') || []) || {}).modelId
                }
            }
        }));
    }

}, {

    live: true

});
