block('b-pic-selector')(

    def()(function() {
        var images = this.ctx.images || [],
            gallery = images.filter(function(image) {
                return image.image_type !== 'small';
            }),
            hasSmall = gallery.length < images.length;

        return applyNext({
            gallery: gallery,
            hasSmall: hasSmall
        });
    }),

    js()(function() {
        var ctx = this.ctx;

        return {
            cid: ctx.cid,
            clientId: ctx.clientId,
            gallery: this.gallery,
            errorMessages: {
                toobig: iget2('b-pic-selector', 'razmer-fayla-bolshe-dopustimogo', 'Размер файла больше допустимого ({foo} МБ)', {
                    foo: 10
                }),
                format: iget2(
                    'b-pic-selector',
                    'nedopustimyy-tip-fayla-ispolzuyte',
                    'Недопустимый тип файла, используйте графические форматы GIF, JPEG, PNG'
                ),
                'url-empty': iget2('b-pic-selector', 'ukazhite-ssylku-na-kartinku', 'Укажите ссылку на картинку'),
                'url-invalid': iget2('b-pic-selector', 'ukazana-nekorrektnaya-ssylka', 'Указана некорректная ссылка'),
                generic: iget2('b-pic-selector', 'oshibka-dobavleniya-fayla', 'Ошибка добавления файла'),
                textual: iget2('b-pic-selector', 'oshibka-s-servera', 'Ошибка с сервера')
            }
        };
    }),

    content()(function() {
        var popupHints = [],
            mediaType = this.ctx.mediaType,
            isTextMediaType = mediaType === 'text';

        isTextMediaType &&
            popupHints.push(iget2(
                'b-pic-selector',
                'k-reklame-v-direkte',
                'К рекламе в Директе можно добавить как классические (с соотношением сторон от 1:1 до 3:4/4:3), так и широкоформатные изображения — они могут показываться на разных площадках. Чтобы ваши объявления с картинками получили хороший охват, мы рекомендуем создать в каждой группе сразу два варианта одного и того же объявления со стандартным и широкоформатным изображением.'
            ));

        return [
            {
                block: 'b-layout-table',
                mods: {
                    layout: 'gap'
                },
                mix: [{
                    block: 'b-pic-selector',
                    elem: 'layout'
                }],
                content: [
                    (u._.isUndefined(this.ctx.hasTitle) || this.ctx.hasTitle) && {
                        elem: 'row',
                        content: [
                            {
                                elem: 'cell',
                                content: {
                                    block: 'b-page-title',
                                    mods: {
                                        size: 'm'
                                    },
                                    mix: [{
                                        block: 'b-pic-selector',
                                        elem: 'header'
                                    }],
                                    content: {
                                        elem: 'title',
                                        content: iget2('b-pic-selector', 'izobrazhenie', 'Изображение')
                                    }
                                }
                            },
                            {
                                elem: 'gap'
                            },
                            {
                                elem: 'cell',
                                content: [
                                    {
                                        block: 'b-help-link',
                                        mods: {
                                            type: 'modal',
                                            margin: 'no'
                                        },
                                        stretched: true,
                                        mix: [{
                                            block: 'b-pic-selector',
                                            elem: 'help-link'
                                        }],
                                        url: u.getHelpUrl('image'),
                                        text: iget2('b-pic-selector', 'usloviya-pokaza-izobrazheniya', 'Условия показа изображения')
                                    },
                                    !u.consts('domains').tr && [
                                        '<br />',
                                        {
                                            block: 'b-help-link',
                                            mods: {
                                                type: 'modal',
                                                margin: 'no'
                                            },
                                            stretched: true,
                                            mix: [{
                                                block: 'b-pic-selector',
                                                elem: 'help-link'
                                            }],
                                            url: u.getHelpUrl('image-ad-rules'),
                                            text: iget2('b-pic-selector', 'trebovaniya-moderacii-k-izobrazheniyu', 'Требования модерации к изображению')
                                        }
                                    ]
                                ]
                            }
                        ]
                    },
                    (!this.ctx.hasTitle && !u._.isUndefined(this.ctx.hasTitle)) && {
                        elem: 'row',
                        mix: { block: 'b-pic-selector', elem: 'titleless-row' },
                        content: [
                            { elem: 'cell' },
                            { elem: 'gap' },
                            {
                                elem: 'cell',
                                mix: { block: 'b-pic-selector', elem: 'titleless-cell' },
                                content: [
                                    {
                                        block: 'b-help-link',
                                        mods: {
                                            type: 'modal',
                                            margin: 'no'
                                        },
                                        stretched: true,
                                        mix: [{
                                            block: 'b-pic-selector',
                                            elem: 'help-link'
                                        }],
                                        url: u.getHelpUrl('image'),
                                        text: iget2('b-pic-selector', 'usloviya-pokaza-izobrazheniya', 'Условия показа изображения')
                                    },
                                    !u.consts('domains').tr && [
                                        '<br />',
                                        {
                                            block: 'b-help-link',
                                            mods: {
                                                type: 'modal',
                                                margin: 'no'
                                            },
                                            stretched: true,
                                            mix: [{
                                                block: 'b-pic-selector',
                                                elem: 'help-link'
                                            }],
                                            url: u.getHelpUrl('image-ad-rules'),
                                            text: iget2('b-pic-selector', 'trebovaniya-moderacii-k-izobrazheniyu', 'Требования модерации к изображению')
                                        }
                                    ]
                                ]
                            }
                        ]
                    },
                    {
                        elem: 'row',
                        content: [
                            {
                                elem: 'cell',
                                colspan: 3,
                                mix: [{
                                    block: 'b-pic-selector',
                                    elem: 'ui'
                                }],
                                content: popupHints.map(function(hintText) {
                                    return {
                                        block: 'b-pic-selector',
                                        elem: 'hint',
                                        content: hintText
                                    };
                                })
                            }
                        ]
                    },
                    {
                        elem: 'row',
                        content: [
                            {
                                elem: 'cell',
                                mix: [{
                                    block: 'b-pic-selector',
                                    elem: 'ui'
                                }],
                                content: {
                                    block: 'b-pic-selector',
                                    elem: 'ui-box',
                                    elemMods: {
                                        type: this.mods.type
                                    },
                                    isTextMediaType: isTextMediaType
                                }
                            },
                            {
                                elem: 'gap',
                                mix: [{
                                    block: 'b-pic-selector',
                                    elem: 'gap'
                                }]
                            },
                            {
                                elem: 'cell',
                                mix: [{
                                    block: 'b-pic-selector',
                                    elem: 'info'
                                }],
                                content: {
                                    block: 'b-pic-selector',
                                    elem: 'preview',
                                    elemMods: {
                                        type: this.mods.type
                                    }
                                }
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'paranja',
                content: {
                    elem: 'file-loading',
                    content: {
                        block: 'spin',
                        js: true,
                        mods: {
                            theme: 'gray-48',
                            progress: 'yes'
                        }
                    }
                }
            },
            {
                elem: 'editor-controls',
                content: [
                    {
                        block: 'button',
                        mods: {
                            size: 's'
                        },
                        mix: [{
                            block: 'b-pic-selector',
                            elem: 'action',
                            elemMods: {
                                type: 'back'
                            }
                        }],
                        content: iget2('b-pic-selector', 'nazad', '← Назад')
                    },
                    {
                        elem: 'save-button'
                    },
                    {
                        elem: 'cancel-button'
                    },
                    {
                        block: 'icon-text',
                        mods: { theme: 'alert', size: 'ms' },
                        mix: [{
                            block: 'b-pic-selector',
                            elem: 'crop-error'
                        }]
                    }
                ]
            },
            this.ctx.content || ''
        ];
    }),

    elem('preview').content()({
        block: 'b-banner-preview',
        showThumbnail: true,
        showVCard: true,
        hideBid: true,
        hideAdditions: true,
        hideSitelinks: true,
        mods: {
            type: 'image',
            updatable: 'yes'
        },
        //нужно чтобы сработало условие в превью ctx.showThumbnail && banner.image
        banner: {
            image: 'default'
        }
    }),

    // превью для РМП строится на клиенте по данным из модели
    elem('preview').elemMod('type', 'mobile-content').content()(''),

    elem('ui-box').content()(function() {
        return [
            {
                block: 'icon-text',
                mods: { theme: 'alert', size: 'ms' },
                mix: [{
                    block: 'b-pic-selector',
                    elem: 'err'
                }],
                text: 'error'
            },
            {
                block: 'icon-text',
                mods: { theme: 'alert', size: 'ms' },
                mix: [{
                    block: 'b-pic-selector',
                    elem: 'text-err'
                }],
                text: 'error'
            },
            {
                elem: 'load-choices',
                content: [
                    {
                        elem: 'noimg',
                        content: [
                            {
                                elem: 'noimg-title',
                                content: iget2('b-pic-selector', 'izobrazhenie-ne-dobavleno', 'Изображение не добавлено')
                            },
                            {
                                elem: 'buttons'
                            }
                        ]
                    },
                    {
                        elem: 'imginfo',
                        content: [
                            {
                                elem: 'existing-img',
                                content: [
                                    {
                                        elem: 'table',
                                        content: [
                                            {
                                                elem: 'row',
                                                content: [
                                                    {
                                                        elem: 'cell',
                                                        elemMods: {
                                                            position: 'l'
                                                        },
                                                        content: {
                                                            block: 'image',
                                                            mix: [{
                                                                block: 'b-pic-selector',
                                                                elem: 'existing'
                                                            }],
                                                            url: ''
                                                        }
                                                    },
                                                    {
                                                        elem: 'cell',
                                                        elemMods: {
                                                            position: 'c'
                                                        }
                                                    },
                                                    {
                                                        elem: 'cell',
                                                        content: [
                                                            {
                                                                elem: 'imagename'
                                                            },
                                                            {
                                                                block: 'button',
                                                                mix: [
                                                                    {
                                                                        block: 'b-pic-selector',
                                                                        elem: 'action',
                                                                        elemMods: {
                                                                            type: 'remove'
                                                                        }
                                                                    }
                                                                ],
                                                                content: iget2('b-pic-selector', 'udalit', 'Удалить')
                                                            }
                                                        ]
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        elem: 'line'
                                    }
                                ]
                            },
                            {
                                elem: 'table',
                                content: [
                                    {
                                        elem: 'row',
                                        content: [
                                            {
                                                elem: 'cell',
                                                elemMods: {
                                                    position: 'l'
                                                },
                                                content: [
                                                    {
                                                        elem: 'assign-other',
                                                        content: iget2('b-pic-selector', 'dobavit-drugoe', 'Добавить другое:')
                                                    },
                                                    {
                                                        elem: 'assign-other-all',
                                                        content: iget2('b-pic-selector', 'dobavit-vsem', 'Добавить всем:')
                                                    }
                                                ]
                                            },
                                            {
                                                elem: 'cell',
                                                elemMods: {
                                                    position: 'c'
                                                }
                                            },
                                            {
                                                elem: 'cell',
                                                content: {
                                                    elem: 'buttons'
                                                }
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                elem: 'multi-remove',
                                content: [
                                    {
                                        elem: 'line'
                                    },
                                    {
                                        elem: 'table',
                                        content: [
                                            {
                                                elem: 'row',
                                                content: [
                                                    {
                                                        elem: 'cell',
                                                        elemMods: {
                                                            position: 'l'
                                                        }
                                                    },
                                                    {
                                                        elem: 'cell',
                                                        elemMods: {
                                                            position: 'c'
                                                        }
                                                    },
                                                    {
                                                        elem: 'cell',
                                                        content: {
                                                            elem: 'btn-container',
                                                            content: {
                                                                block: 'button',
                                                                mix: [
                                                                    {
                                                                        block: 'b-pic-selector',
                                                                        elem: 'action',
                                                                        elemMods: {
                                                                            type: 'multidel'
                                                                        }
                                                                    }
                                                                ],
                                                                name: 'multidel',
                                                                content: iget2('b-pic-selector', 'udalit-u-vseh-obyavleniy', 'Удалить у всех объявлений')
                                                            }
                                                        }
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'editor',
                content: [
                    {
                        elem: 'upload-by-url',
                        content: {
                            elem: 'table',
                            content: {
                                elem: 'row',
                                content: [
                                    {
                                        elem: 'cell',
                                        elemMods: {
                                            layout: 'upload-url-l'
                                        },
                                        content: iget2('b-pic-selector', 'ssylka', 'Ссылка:')
                                    },
                                    {
                                        elem: 'cell',
                                        mix: {
                                            block: 'b-pic-selector',
                                            elem: 'upload-url-cell'
                                        },
                                        content: {
                                            block: 'input',
                                            mix: [{
                                                block: 'b-pic-selector',
                                                elem: 'url-input'
                                            }],
                                            id: 'url-input',
                                            name: 'url-input',
                                            content: {
                                                elem: 'control'
                                            }
                                        }
                                    },
                                    {
                                        elem: 'cell',
                                        elemMods: {
                                            layout: 'upload-url-r'
                                        },
                                        content: {
                                            block: 'button',
                                            mix: [
                                                {
                                                    block: 'b-pic-selector',
                                                    elem: 'action',
                                                    elemMods: {
                                                        type: 'fetch-url'
                                                    }
                                                }
                                            ],
                                            content: iget2('b-pic-selector', 'zagruzit', 'Загрузить')
                                        }
                                    }
                                ]
                            }
                        }
                    },
                    {
                        elem: 'upload-from-local',
                        content: {
                            block: 'attach',
                            mods: { size: 's', theme: 'normal' },
                            mix: [{
                                block: 'b-pic-selector',
                                elem: 'file-input'
                            }],
                            name: 'image',
                            holder: true
                        }
                    },
                    {
                        elem: 'choose-message',
                        elemMods: {
                            type: this.ctx.elemMods.type
                        }
                    },
                    {
                        elem: 'canvas',
                        elemMods: {
                            type: this.ctx.elemMods.type
                        }
                    }
                ]
            },
            {
                elem: 'gallery'
            }
        ];
    }),

    elem('buttons').content()(function() {
        return [
            {
                elem: 'btn-container',
                content: {
                    block: 'button',
                    mix: {
                        block: 'b-pic-selector',
                        elem: 'action',
                        elemMods: {
                            type: 'local'
                        }
                    },
                    content: iget2('b-pic-selector', 'zagruzit-s-kompyutera', 'Загрузить с компьютера')
                }
            },
            {
                elem: 'btn-container',
                content: {
                    block: 'button',
                    mix: {
                        block: 'b-pic-selector',
                        elem: 'action',
                        elemMods: {
                            type: 'url'
                        }
                    },
                    content: iget2('b-pic-selector', 'zagruzit-iz-interneta', 'Загрузить из интернета')
                }
            },
            {
                elem: 'btn-container',
                content: {
                    block: 'button',
                    mods: {
                        disabled: this.gallery.length ? '' : 'yes'
                    },
                    mix: {
                        block: 'b-pic-selector',
                        elem: 'action',
                        elemMods: {
                            type: 'gallery'
                        }
                    },
                    content: iget2('b-pic-selector', 'vybrat-iz-ranee-zagruzhennyh', 'Выбрать из ранее загруженных')
                }
            },
            !this.gallery.length && this.hasSmall ?
                {
                    elem: 'only-small-container',
                    content: iget2('b-pic-selector', 'u-vas-net-izobrazheniy', 'У вас нет изображений больше 450 пикселей по короткой стороне')
                } :
            ''
        ];
    }),

    elem('choose-message').content()(function() {
        return [
            iget2('b-pic-selector', 'dopustimyy-format-jpg-png', 'Допустимый формат: JPG, PNG, GIF'),
            '<br />',
            iget2('b-pic-selector', 'obyom-do-10-mb', 'Объём: до 10 МБ'),
            '<br />',
            iget2('b-pic-selector', 'razmer-izobrazheniya', 'Размер изображения:'),
            '<br />',
            iget2(
                'b-pic-selector',
                'mdash-pri-sootnoshenii-storon',
                '&mdash; при соотношении сторон от 1:1 до 3:4/4:3 — от 450 до 5000 пикселей по каждой стороне;'
            ),
            '<br />',
            iget2(
                'b-pic-selector',
                'mdash-pri-sootnoshenii-storon-100',
                '&mdash; при соотношении сторон 16:9 — от 1080 &times; 607 до 5000 &times; 2812 пикселей.'
            )
        ];
    }),

    elem('choose-message').elemMod('type', 'mobile-content').content()(function() {
        return [
            iget2('b-pic-selector', 'dopustimyy-format-jpg-png', 'Допустимый формат: JPG, PNG, GIF'),
            '<br />',
            iget2('b-pic-selector', 'obyom-do-10-mb', 'Объём: до 10 МБ'),
            '<br />',
            iget2('b-pic-selector', 'razmer-izobrazheniya', 'Размер изображения:'),
            '&nbsp;',
            iget2('b-pic-selector', 'ot-1080-times-607', 'от 1080 &times; 607 до 5000 &times; 2812 пикселей при соотношении сторон 16:9.')
        ];
    }),

    elem('canvas').content()({
        block: 'banner-image-crop',
        mods: {
            type: 'single'
        },
        mix: {
            block: 'b-pic-selector',
            elem: 'crop'
        },
        type: 'text'
    }),

    elem('canvas').elemMod('type', 'mobile-content').content()({
        block: 'banner-image-crop',
        mods: {
            type: 'single'
        },
        mix: {
            block: 'b-pic-selector',
            elem: 'crop'
        },
        type: 'mobile-content'
    }),

    elem('gallery').content()(function() {

        var galleryItems = [],
            i;

        for (i = 0; i < 51; i++) {
            galleryItems.push(i);
        }

        return [
            this.hasSmall ?
                {
                    block: 'b-notice-tooltip',
                    mods: {
                        corners: 'top'
                    },
                    mix: {
                        block: 'b-pic-selector',
                        elem: 'notice-small-hidden'
                    },
                    key: 'informed_small_pictures_not_supported',
                    content: iget2(
                        'b-pic-selector',
                        'ranee-zagruzhennye-izobrazheniya-razmerom',
                        'Ранее загруженные изображения размером меньше 450 пикселей по короткой стороне не показываются в списке и недоступны для выбора'
                    )
                } :
                '',
            {
                elem: 'piclist',
                content: galleryItems.map(function() {
                    return {
                        elem: 'piclist-item'
                    };
                })
            },
            {
                elem: 'gallery-pagination',
                content: [
                    {
                        elem: 'line',
                        elemMods: { type: 'gallery-pagination' }
                    },
                    {
                        block: 'button',
                        mix: [{
                            block: 'b-pic-selector',
                            elem: 'action',
                            elemMods: {
                                type: 'gallery-back'
                            }
                        }],
                        content: '←'
                    },
                    {
                        elem: 'gallery-pagination-text'
                    },
                    {
                        block: 'button',
                        mix: [
                            {
                                block: 'b-pic-selector',
                                elem: 'action',
                                elemMods: {
                                    type: 'gallery-fwd'
                                }
                            }
                        ],
                        content: '→'
                    }
                ]
            }
        ];
    }),

    elem('cancel-button').content()(function() {
        return {
            block: 'button',
            mix: [
                {
                    block: 'b-pic-selector',
                    elem: 'action',
                    elemMods: {
                        type: 'cancel'
                    }
                }
            ],
            content: iget2('b-pic-selector', 'otmena', 'Отмена')
        };
    }),

    elem('save-button').content()(function() {
        return {
            block: 'button',
            mix: [
                {
                    block: 'b-pic-selector',
                    elem: 'action',
                    elemMods: {
                        type: 'save'
                    }
                }
            ],
            content: iget2('b-pic-selector', 'sohranit', 'Сохранить')
        };
    }),

    elem('table').tag()('table'),

    elem('row').tag()('tr'),

    elem('cell').tag()('td'),

    elem('hint').tag()('p')
);
