BEM.DOM.decl({ block: 'b-pic-selector', implements: 'i-outboard-controls' }, {

    /**
     * Объект с координатами и размерами выбранной области
     *
     * @typedef {Object} jQueryCropSelection
     * @property {Number} x координата x1
     * @property {Number} y координата y1
     * @property {Number} x2 координата x2
     * @property {Number} y2 координата y2
     * @property {Number} w ширина
     * @property {Number} h высота
     */

    /**
     * @type {Number}
     * Максимальный размер изображения в байтах
     */
    _maxFileSize: 10 * 1024 * 1024,

    /**
     * @type {Number}
     * сколько картинок в 1 секции Галереи
     */
    _picsPerGallery: 0,

    /**
     * @type {Number}
     * текущая секция Галереи
     */
    _currentGallerySection: 0,

    /**
     * @type {Number}
     * до какой высоты обрезать картинку
     */
    _picWidth: 90,

    /**
     * @type {Number}
     * до какой ширины обрезать картинку
     */
    _picHeight: 90,

    /**
     * @type {Number}
     * до какой высоты обрезать картинку с соотношением сторон 16:9
     */
    _picWidth169: 300,

    /**
     * @type {Number}
     * до какой ширины обрезать картинку с соотношением сторон 16:9
     */
    _picHeight169: 169,

    /**
     * @type {Number}
     * Таймаут загрузки изображения
     */
    _fileUploadTimeout: 180000,

    /**
     * @type {Number}
     * Таймаут загрузки посредством объекта xhr
     */
    _ajaxTimeout: 60000,

    /**
     * @type {String}
     * URL изображения
     */
    _uploadUrl: null,

    onSetMod: {
        js: function() {
            this._gallery = this.params.gallery || [];

            this._clientId = this.params.clientId;

            this._picsPerGallery = this.elem('piclist-item').size();

            this._fileInputBlock = this.findBlockOn('file-input', 'attach');

            this._fileInputBlock.on('reset', function() {
                this._fileInput = this._fileInputBlock.findElem('control');
            }, this);

            this._urlInput = this.findBlockOn('url-input', 'input');

            this._onCropChangeThrottled = $.throttle(this._onCropChange, 10, this);

            this._initEvents();
        },

        editor: function(modName, modVal) {
            var handler = ({
                init: function() {
                    this._initialReset();
                },
                local: function() {
                    this._showFileLocalUploadPage();
                },
                url: function() {
                    this._showFileUrlUploadPage();
                },
                gallery: function() {
                    this._showGalleryPage();
                },
                loaded: function() {
                    // DIRECT-68147: Не добавляется изображение при массовом редактировании РО
                    // помогает отработать css классу .b-pic-selector_editor_loaded .b-pic-selector__crop
                    // по которому выставляется display: block,
                    // который в свою очередь помогает правильно вычислять размеры изображение в i-jquery__jcrop.js
                    this.afterCurrentEvent(function() {
                        this._showImageCropPage();
                    });
                }
            })[modVal];

            this.trigger('selector-mode', handler && modVal);

            handler && handler.call(this);
        }
    },

    /**
     * Возвращает объект, хранящий состояние для баннера, редактируемого в текущий момент.
     * Если такого объекта нет, создается новый.
     * @returns {Object}
     * @private
     */
    _getState: function() {
        return this.__self._getState(this._bannerId);
    },

    /**
     * Очищает состояние, которые установили во время обрезки картинки
     * @private
     */
    _initialReset: function() {
        var model = this.getImageModel();

        this._setThumb(model.get('mds_group_id'), model.get('image') || '', model.get('image_type') === 'wide');

        this._getState()
            .ajaxFileSendStop()
            .ajaxSendStop();

        this.delMod('last-state')
            .setMod('interactive', 'yes')
            ._hideErrors();

        this._resetBannerPreview();
    },

    /**
     * Сбрасывает отображение превью баннера
     * @param {String} [url]
     * @protected
     */
    _resetBannerPreview: function(url) {
        var imageElem = this._getBannerPreview().elem('image');

        if (url) {
            imageElem.attr('src', url).css({
                position: 'absolute',
                width: this._picWidth + 'px',
                height: this._picHeight + 'px',
                'max-width': '',
                'max-height': ''
            });
        } else {
            imageElem.css({
                display: 'inline',
                position: 'static',
                width: '',
                height: '',
                'max-height': '',
                top: '',
                left: '',
                clip: ''
            });
        }
    },

    /**
     * Приведение компонента в первоначальное состояние
     * @private
     */
    _reset: function() {
        this._initialReset();

        this._fileInputBlock.resetFile();

        this._urlInput.val('');

        this.imageData = null;

        this._uploadUrl = null;

        this._getBannerImageCrop().reset();
    },

    /**
     * Инициализация событий на блоке и его элементах
     * Слушатель изменения модели, изображений в галереи
     * @private
     */
    _initEvents: function() {
        var picListItems = this.elem('piclist-item');

        this._getBannerImageCrop()
            .on('select', function(e, data) {
                this._onCropChangeThrottled(data.selection, data.normalizedSelection);
            }, this)
            .on('error', function(e, error) {
                this._onCropChangeThrottled(error.selection, error.normalizedSelection, error.text);
            }, this);

        this.bindTo(picListItems, 'click', function(e) {
            var picListItem = $(e.currentTarget),
                id = +picListItem.attr('data-gallery-id'),
                img = this._gallery[id];

            if (isNaN(id) || !img) {
                this
                    ._setThumb('')
                    ._setButtonsDisabledState({ save: true });
            } else {
                this
                    .delMod(picListItems, 'selected')
                    .setMod(picListItem, 'selected', 'yes');

                this
                    ._setThumb(img.mds_group_id, img.image, img.image_type === 'wide')
                    ._setButtonsDisabledState({ save: false });
            }
        });

        this.bindTo('action', 'click', function(e) {
            var button = $(e.currentTarget),
                buttonBEM = button.bem('button');

            if (buttonBEM.hasMod('disabled', 'yes')) return true;

            this._doAction(this.getMod(button, 'type'));
        });

        this._urlInput.bindTo('keypress', function(e) {
            e.keyCode == 13 && this._fetchURL();
        }.bind(this));

        this._fileInputBlock.on('change', this._onFileInputChanged, this);
    },

    /**
     * Действие на нажатие определенной кнопки.
     * @param {String} type
     * @private
     */
    _doAction: function(type) {
        var mod = this.getMod('editor');

        switch (type) {
            case 'local':
                this._initByClick = true;
                break;
            case 'fetch-url':
                return this._fetchURL();
            case 'back':
                switch (mod) {
                    case 'loaded':
                        return this.setMod('editor', this.getMod('last-state') || 'local');
                    default:
                        return this.setMod('editor', 'init');
                }
                // cyn@TODO: В DIRECT-53578 оторвать disable-next-line и починить
                // eslint-disable-next-line no-unreachable
                break;
            case 'save':
                this.trigger('save-action');

                if (mod == 'loaded' || mod == 'gallery') {
                    return;
                }
                break;
            case 'cancel':
                this.trigger('cancel-action');

                return;
            case 'gallery-back':
            case 'gallery-fwd':
                return this._showGalleryPage(this._currentGallerySection + (type == 'gallery-fwd' ? 1 : -1));
            case 'remove':
            case 'multidel':

                this._setModel(null);
                this._updateBannerPic();

                return;
        }

        this.setMod('editor', type);

        return this;
    },

    /**
     * Показывает View для загрузки изображения с компьютера пользователя
     * @private
     */
    _showFileLocalUploadPage: function() {
        this._reset();

        this
            .setMod('last-state', 'local')
            ._setButtonsDisabledState({ back: false, save: true, cancel: false });

        // File API позволяет input=file открыть файловое окно посредством вызова метода click
        if (this._initByClick && this._fileInput.get(0).files && window.FormData) {
            this._initByClick = false;
            try {
                this._fileInput.get(0).click();
            } catch (err) {}
        }
    },

    /**
     * Событие, срабатывает на выбор файла пользователем. Первично проверяет на ошибки.
     * Если ошибок нет, устанавливается модификатор(статус) loading
     * @return {Boolean}
     * @private
     */
    _onFileInputChanged: function() {
        var file = this._fileInput.get(0).files[0] || null;

        this._hideErrors();

        if (!file) {
            this._fileInput.val('');

            return false;
        }

        if (file.size > this._maxFileSize) {
            this._showError('toobig');

            return false;
        }

        if (file.type !== '' && !/^image\//.test(file.type)) {
            this._showError('format');

            return false;
        }

        this._uploadImage('local');

        return true;
    },

    /**
     * Показ View для загрузки изображения с помощью URL
     * @private
     */
    _showFileUrlUploadPage: function() {
        this._reset();

        this
            .setMod('last-state', 'url')
            ._setButtonsDisabledState({ back: false, save: true, cancel: false });
    },

    /**
     * Разбор значения, введенного пользователем в инпут.
     * Если значение является ссылкой - загрузка изображения.
     * @private
     */
    _fetchURL: function() {
        var val = this._urlInput.val().trim();

        if (u.isEmpty(val)) { return this._showError('url-empty'); }

        if (!u.validateHref(val)) { return this._showError('url-invalid'); }

        this._uploadImage('url');
    },

    /**
     * Обновляет отображение превьюшек блока в зависимости от данных модели
     * @protected
     */
    _updateBannerPic: function() {
        var model = this.getImageModel(),
            image = model.get('image'),
            imageName = model.get('image_name') || '',
            mdsGroupId = model.get('mds_group_id');

        this.elem('imagename')
            .html(u.hellipSplit(imageName, 27, u.escapeHtmlSafe))
            .attr('title', imageName);

        // в existing указываем url миниатюры без параметра широкого изображения
        this.elem('existing').attr('src', this._makeThumbURL(mdsGroupId, image));

        this._setThumb(mdsGroupId, image, model.get('image_type') === 'wide');

        this.setMod('img', image ? 'yes' : 'no');
    },

    /**
     * Показ определенной ошибки по идентификатору
     * @param {String} errorName идентификатор ошибки, по которому показывается ошибка из хеша this.params.errorMessages
     * @param {String} [text] текст ошибки, если идентификатор равен textual
     * @returns {BEM.DOM}
     * @private
     */
    _showError: function(errorName, text) {
        var err = this.elem('err'),
            textErr = this.elem('text-err');

        this
            .setMod('editor', this.getMod('last-state') || 'local')
            .setMod('interactive', 'yes');

        if (errorName === 'textual' && text) {
            this.findBlockOn(textErr, 'icon-text').setText(text);
            this.setMod(textErr, 'visible', 'yes');
        } else {
            this.findBlockOn(err, 'icon-text').setText(this.params.errorMessages[errorName]);
            this.setMod(err, 'visible', 'yes');
        }

        return this;
    },

    /**
     * Скрывает ошибки
     * @returns {BEM.DOM}
     * @private
     */
    _hideErrors: function() {
        return this
            .delMod(this.elem('err'), 'visible')
            .delMod(this.elem('crop-error'), 'visible')
            .delMod(this.elem('text-err'), 'visible');
    },

    /**
     * Меняет статус кнопки (enabled/disabled) согласно переданному хэшу ключей.
     * Ключи хеша - значение модификатора type у элемента action.
     * Значения хеша - Boolean (true - disabled, false - enabled)
     * @param {Object} buttonsStates хеш кнопок, статус которых необходимо изменить.
     * @example
     *  {
     *      save: true,
     *      cancel: false
     *  }
     * @returns {BEM.DOM}
     * @private
     */
    _setButtonsDisabledState: function(buttonsStates) {
        u._.forOwn(buttonsStates, function(disabledState, actionType) {
            var button = this.findBlockOn(this.elem('action', 'type', actionType), 'button');

            button && button.setMod('disabled', disabledState ? 'yes' : '');
        }, this);

        this.trigger('button-state-changed', buttonsStates);

        return this;
    },

    /**
     * Строит URL миниатюры изображения по его идентификатору и показателю большой картинки
     * @param {String} mdsGroupId номер группы в аватарнице
     * @param {String} hash строковый идентификатор изображения
     * @param {Boolean} [isWide=false] указывает на необходимость построить URL большой картинки
     * @returns {String}
     * @private
     */
    _makeThumbURL: function(mdsGroupId, hash, isWide) {
        if (!hash) return '';

        return u.getImageUrl({
            mdsGroupId: mdsGroupId,
            hash: hash,
            size: isWide ? 'wx' + this._picWidth169 : 'x' + this._picWidth
        });
    },

    /**
     * Назначение URL адреса на превью по идентификатору изображения
     * @param {String} mdsGroupId номер группы в Аватарнице
     * @param {String} id строковый идентификатор изображения
     * @param {Boolean} [isWide=false] указывает на необходимость построить URL большой картинки
     * @returns {BEM.DOM}
     * @protected
     */
    _setThumb: function(mdsGroupId, id, isWide) {
        var preview = this._getBannerPreview();

        preview.updateImage(mdsGroupId, id, isWide);
        preview.setMod('type', isWide ? 'image-wide' : 'image');

        preview.elem('thumb').css({
            width: isWide ? this._picWidth169 : this._picWidth + 'px',
            height: isWide ? this._picHeight169 : this._picHeight + 'px',
            'margin-bottom': '6px'
        });

        return this;
    },

    /**
     * Загрузка изображения. Загрузка может загружать изображения с локальной файловой системы пользователя, либо по
     * URL.
     * @param {String} type тип загрузки изображения (url или local)
     * @private
     */
    _uploadImage: function(type) {
        var fromURL = type === 'url',
            fromLocal = type === 'local';

        if (fromURL || fromLocal) {
            this
                .setMod('editor', 'loading')
                .setMod('interactive', 'no')
                ._setButtonsDisabledState({ back: false, save: true, cancel: false });
        }

        fromURL && this._uploadImageFromUrl();

        fromLocal && this._uploadImageFromLocal();
    },

    /**
     * Загрузка изображения по URL
     * @private
     */
    _uploadImageFromUrl: function() {
        this._uploadUrl = this._urlInput.val().trim();

        this._getState().ajaxSend(
            this._getPostParams({ url: this._uploadUrl }),
            this._afterImageUploaded.bind(this),
            this._afterImageUploaded.bind(this),
            { type: 'POST', timeout: this._fileUploadTimeout });
    },

    /**
     * Загрузка изображения с локальной файловой системы пользователя.
     * @private
     */
    _uploadImageFromLocal: function() {
        this._getState().ajaxFileSend(
            this._getPostParams({ image: this._fileInput }),
            this._afterImageUploaded.bind(this),
            this._afterImageUploaded.bind(this),
            { timeout: this._fileUploadTimeout });
    },

    /**
     * Событие, срабатывающее на возврат ответа от сервера, после загрузки изображения
     * @param {Object} data
     * @param {String} data.error
     * @param {Number} data.width
     * @param {Number} data.height
     * @param {String} data.image
     * @param {Number} data.orig_width
     * @param {Number} data.orig_height
     * @param {String} data.upload_id
     * @private
     */
    _afterImageUploaded: function(data) {
        if (!data) { return this._showError('generic'); }

        if (data.error) { return this._showError('textual', data.error); }

        this.imageData = {
            previewWidth: data.width,
            previewHeight: data.height,
            previewId: data.image,
            origWidth: data.orig_width,
            origHeight: data.orig_height,
            uploadId: data.upload_id
        };

        this.setMod('editor', 'loaded');
    },

    /**
     * Показывает View с функциональностью обрезки изображения
     * @returns {BEM.DOM}
     * @private
     */
    _showImageCropPage: function() {
        var data = this.imageData,
            previewUrl = '/storage/' + this._clientId + '/banner_images_uploads/' + data.previewId;

        this._setButtonsDisabledState({ back: false, save: false, cancel: false });

        this._resetBannerPreview(previewUrl);

        this.setMod('crop-plugin-lock', 'yes');

        this._getBannerImageCrop()
            .delMod('disabled')
            .init({
                previewUrl: previewUrl,
                editorWidth: data.previewWidth,
                editorHeight: data.previewHeight,
                origImageWidth: data.origWidth,
                origImageHeight: data.origHeight
            })
            .then(function() {
                this.delMod('crop-plugin-lock');
                this.setMod('interactive', 'yes');
            }.bind(this));

        return this;
    },

    /**
     * Отображает ошибки валидации размеров вырезки, если они есть
     * Управляет статусом кнопки сохранить в зависимости от наличия ошибок
     * @param {String} [error] Сообщение об ошибке
     * @returns {BEM.DOM}
     * @private
     */
    _showCropWarnings: function(error) {
        this._hideErrors();

        if (!error) {
            this._setButtonsDisabledState({ save: false });
        } else {
            this
                ._setButtonsDisabledState({ save: true })
                .setMod(this.elem('crop-error'), 'visible', 'yes')
                .findBlockOn('crop-error', 'icon-text').setText(error);
        }

        return this;
    },

    /**
     * @todo Еще допилить, чтобы красиво отображалось. Подчистить код
     * Показывает превью в блоке b-banner-prewview
     * @param {jQueryCropSelection} selection Выбранные координаты обрезки
     * @returns {Object}
     * @protected
     */
    _showPreview: function(selection) {
        var preview = this._getBannerPreview(),
            imageData = this.imageData,
            isWide = this._getBannerImageCrop().getPreservedRatio() === '16:9',
            picWidth = isWide ? this._picWidth169 : this._picWidth,
            picHeight = isWide ? this._picHeight169 : this._picHeight,
            width, height, x, y, x2, y2, coef, rate;

        if (!preview) {
            return this;
        }

        if (selection.w >= selection.h) {
            rate = imageData.origWidth / imageData.previewWidth;
            coef = picWidth / selection.w * rate;
        } else {
            rate = imageData.origHeight / imageData.previewHeight;
            coef = picHeight / selection.h * rate;
        }

        x = Math.round(coef * selection.x / rate);
        y = Math.round(coef * selection.y / rate);
        x2 = Math.round(coef * selection.x2 / rate);
        y2 = Math.round(coef * selection.y2 / rate);
        width = Math.round(imageData.previewWidth * coef) + 'px';
        height = Math.round(imageData.previewHeight * coef) + 'px';

        preview.elem('image').css({
            position: 'absolute',
            display: 'block',
            width: width,
            height: height,
            'max-height': height,
            clip: 'rect(' + y + 'px ' + x2 + 'px ' + y2 + 'px ' + x + 'px)',
            top: '-' + y + 'px',
            left: '-' + x + 'px'
        });

        preview.elem('thumb').css({
            width: Math.round(x2 - x) + 'px',
            height: Math.round(y2 - y) + 'px',
            'margin-bottom': '6px'
        });

        preview.setMod('type', isWide ? 'image-wide' : 'image');

        return this;
    },

    _onCropChange: function(selection, normalizedSelection, error) {
        if (!this.hasMod('crop-plugin-lock', 'yes')) {
            this._cropSelection = normalizedSelection;
            this._showPreview(selection);
            this._showCropWarnings(error);
        }
    },

    /**
     * Сохранение обрезанного изображения с отправкой на сервер
     * @private
     */
    _saveCrop: function() {
        var promise = $.Deferred(),
            state = this._getState(),
            image = this.imageData;

        this._getBannerImageCrop().setMod('disabled', 'yes');
        this._setModel({ image_processing_state: 'pending' }, state);
        this.trigger('save');

        state.ajaxSend(
            {
                cid: this.params.cid,
                ulogin: u.consts('ulogin'),
                cmd: 'ajaxResizeBannerImage',
                upload_id: image.uploadId,
                image: image.previewId,
                x1: this._cropSelection.x,
                x2: this._cropSelection.x2,
                y1: this._cropSelection.y,
                y2: this._cropSelection.y2

            },
            function(data) {
                if (!data || typeof data.image == 'undefined' || data.error) {
                    promise.reject(data)
                } else {
                    promise.resolve(data);
                }
            },
            function() { promise.reject(); },
            { type: 'GET', timeout: this._ajaxTimeout });

        promise
            .then(function(data) {
                this._setModel({
                    image: data.image,
                    image_name: data.name,
                    image_type: data.image_type,
                    image_width: data.image_width,
                    image_height: data.image_height,
                    source_image: this.hasMod('last-state', 'local') ? 'file' : this.getMod('last-state'),
                    image_source_url: this.hasMod('last-state', 'url') ? this._uploadUrl : '',
                    image_processing_state: '',
                    mds_group_id: data.mds_group_id
                }, state);
                this.trigger('save');
            }.bind(this))
            .fail(function(data) {
                this._setModel({
                    image_processing_state: data && typeof data.error_state == 'string' ? data.error_state : 'error'
                }, state);
            }.bind(this))
            .then(function() {
                state.ajaxSendStop();
            }.bind(this));

        return promise;
    },

    /**
     * Установка значений в модель
     * @param {Object} [data]
     * @param {Object} [state] объект, хранящий состояние попапа для текущего баннера (для передачи нужного состояния в
     *     асинхронных операциях)
     * @private
     */
    _setModel: function(data, state) {
        var model = state ? state.model : this.getImageModel();

        data ? model.update(data) : model.clear();
    },

    /**
     * Возвращает хеш данных, необходимых для отправки изображения на сервер
     * @param {Object} params дополнительные параметры
     * @returns {Object}
     * @private
     */
    _getPostParams: function(params) {
        return u._.extend({
            cid: this.params.cid,
            csrf_token: BEM.blocks['i-global'].param('csrf_token'),
            uid: u.consts('uid'),
            UID: u.consts('UID'),
            ulogin: u.consts('ulogin') || '',
            cmd: 'uploadBannerImage'
        }, params);
    },

    /**
     * Показывает View галереи
     * @private
     */
    _showGalleryPage: function(page) {
        this
            .delMod(this.elem('piclist-item'), 'selected')
            ._setThumb('')
            ._setButtonsDisabledState({ back: false, save: true, cancel: false });

        this._showGallerySection(page || 0);
    },

    /**
     * Формирует определенную страницу галереи сохраненных изображений
     *
     * @param {Number} n Номер страницы. Отсчет ведется с нуля.
     * @private
     */
    _showGallerySection: function(n) {
        var startIndex = this._picsPerGallery * n;

        if (startIndex >= 0 && this._gallery[startIndex]) {

            this._currentGallerySection = n;

            this.elem('piclist-item').each(function(i, el) {
                var id = startIndex + i;

                this._setGalleryItemThumb($(el), id, this._gallery[id]);
            }.bind(this));

            this.elem('gallery-pagination-text').text(
                iget2('b-pic-selector', 'stranica-s-iz-s', 'Страница {foo} из {bar}', {
                    foo: n + 1,
                    bar: Math.ceil(this._gallery.length / this._picsPerGallery)
                })
            );
        }

        this._setButtonsDisabledState({
            'gallery-back': this._currentGallerySection - 1 < 0,
            'gallery-fwd': (this._currentGallerySection + 1) * this._picsPerGallery >= this._gallery.length
        });

        this.setMod(
            this.elem('gallery-pagination'),
            'visible',
                this._gallery.length > this._picsPerGallery ? 'yes' : 'no'
        );

        this.elem('piclist').scrollTop(0);
    },

    /**
     * Формирует определенный элемент галереи сохраненных изображений в зависимости от данных data и идентификатора id
     * Если данных нет - очищает соответствующий элемент elem
     * @param {jQuery} elem
     * @param {Number} id
     * @param {Object} [data]
     * @private
     */
    _setGalleryItemThumb: function(elem, id, data) {
        if (!data) {
            this.setMod(elem, 'visible', 'no');

            return;
        }

        // в piclist-item-img указываем url миниатюры без параметра широкого изображения
        this.findElem(elem, 'piclist-item-img').attr('src', this._makeThumbURL(data.mds_group_id, data.image));
        this.findElem(elem, 'piclist-item-name').text(data.name);

        elem
            .attr('title', data.name)
            .attr('data-gallery-id', id);

        this.setMod(elem, 'visible', 'yes');
    },

    /**
     * Сохранение изображения в модели из галереи
     * @private
     */
    _saveImageFromGallery: function() {
        var id = +this.findElem('piclist-item', 'selected', 'yes').attr('data-gallery-id');

        if (!isNaN(id) && this._gallery[id]) {
            this._setModel({
                image: this._gallery[id].image,
                image_name: this._gallery[id].name,
                image_type: this._gallery[id].image_type,
                image_width: this._gallery[id].image_width,
                image_height: this._gallery[id].image_height,
                source_image: 'gallery',
                image_source_url: '',
                mds_group_id: this._gallery[id].mds_group_id
            });

            this._updateBannerPic();
            this.trigger('save');
        }
    },

    /**
     * Возвращает блок превью баннера
     * @returns {BEM.DOM}
     * @protected
     */
    _getBannerPreview: function() {
        return this._bannerPreview ||
            (this._bannerPreview = this.findBlockInside(this.elem('preview'), 'b-banner-preview'));
    },

    /**
     * Обновляет превью баннера
     * @param {Object} modelParams параметры модели баннера
     * @param {String} modelParams.id id инстанса модели
     * @param {String} modelParams.name имя модели
     * @param {String} modelParams.parentId id инстанса родительской модели
     * @param {String} modelParams.parentName имя родительской модели
     * @protected
     */
    _updateBannerPreview: function(modelParams) {
        this._getBannerPreview().setBanner(modelParams);
    },

    /**
     * Возвращает блок обрезки изображения
     * @returns {BEM.DOM}
     * @private
     */
    _getBannerImageCrop: function() {
        return this._bannerImageCrop || (this._bannerImageCrop = this.findBlockInside('banner-image-crop'));
    },

    /**
     * Подготавливает блок для показа в попапе
     * @param {Object} params
     * @param {Object} params.modelParams параметры модели баннера
     * @param {String} params.modelParams.id id инстанса модели
     * @param {String} params.modelParams.name имя модели
     * @param {String} params.modelParams.parentId id инстанса родительской модели
     * @param {String} params.modelParams.parentName имя родительской модели
     */
    prepareToShow: function(params) {
        this._bannerId = params.modelParams.id;

        this._getState().model = BEM.MODEL.getOrCreate(params.modelParams).get('image_model');

        this._updateBannerPreview(params.modelParams);
        this._updateBannerPic();

        this.setMod('editor', 'init');
    },

    /**
     * Возвращает модель изображения
     * @returns {BEM.MODEL}
     */
    getImageModel: function() {
        return this._getState().model;
    },

    /**
     * Обработчик закрытия попапа при принятии
     */
    provideData: function() {
        var mod = this.getMod('editor');

        if (mod == 'loaded') {
            return this._saveCrop();
        } else if (mod == 'gallery') {
            this._saveImageFromGallery();
        }
    },

    /**
     * Обработчик закрытия попапа при отклонении
     */
    declineChange: function() {
        this.setMod('editor', 'init');
        this.trigger('cancel');

        return this;
    }

}, {

    /**
     * @type {Object}
     * Состояние (модель и xhr запрос для баннеров)
     */
    _state: {},

    /**
     * Возвращает объект, хранящий состояние для баннера, редактируемого в текущий момент.
     * Если такого объекта нет, создается новый.
     * @param {String} bannerId
     * @returns {Object}
     * @private
     */
    _getState: function(bannerId) {
        return this._state[bannerId] ||
            (this._state[bannerId] = {
                model: null,
                ajaxSend: function() {
                    this._ajax || (this._ajax = BEM.create('i-request_type_ajax', {
                        url: u.consts('SCRIPT'),
                        dataType: 'json'
                    }));

                    this._xhr = this._ajax.get.apply(this._ajax, arguments);

                    return this;
                },
                ajaxSendStop: function() {
                    var xhr = this._xhr;

                    xhr && xhr.readyState != 4 && xhr.abort();

                    return this;
                },
                ajaxFileSend: function() {
                    this._fileAjax || (this._fileAjax = BEM.create('i-request_type_file', {
                        url: u.consts('SCRIPT'),
                        type: 'POST',
                        dataType: 'json'
                    }));

                    this._fileAjax.get.apply(this._fileAjax, arguments);

                    return this;
                },
                ajaxFileSendStop: function() {
                    this._fileAjax && this._fileAjax.abort();

                    return this;
                }
            });
    },

    live: true

});
