block('b-potential-report-region')(
    js()(function() {
        return {
            regionsModelId: this.ctx.regionsModelId,
            url: this.ctx.url
        };
    }),

    content()(function() {
        return [
            // свитчер по которому открывается попап аутборда, сам попап рендерится в родительском блоке
            // потому как свитчеров может быть несколько
            {
                block: 'b-outboard-controls',
                js: { id: 'regions-controls' },
                mix: [{
                    block: 'b-potential-report-region',
                    elem: 'switcher'
                }],
                content: {
                    elem: 'switcher',
                    js: {
                        innerBlockParams: { modelId: this.ctx.regionsModelId }
                    },
                    switcher: {
                        block: 'button',
                        mods: {
                            theme: 'normal',
                            disabled: this.mods.disabled
                        },
                        content: iget2('b-potential-report-region', 'utochnit', 'уточнить')
                    }
                }
            },
            {
                elem: 'text',
                content: iget2('b-potential-report-region', 'ili', 'или')
            },
            // кнопка по которой нужно запросить регионы с сервера, указав логины или номера кампаний
            {
                block: 'button',
                mix: [{
                    block: 'b-potential-report-region',
                    elem: 'from-campaign'
                }],
                mods: {
                    theme: 'normal',
                    disabled: this.mods.disabled || this.mods['disabled-from-campaign']
                },
                content: iget2('b-potential-report-region', 'prostavit-region-iz-kampanii', 'проставить регион из кампании')
            },
            // человекочитаемое отображение регионов
            {
                elem: 'selected-regions',
                mix: [{
                    block: 'b-outboard-controls',
                    elem: 'data-hint',
                    elemMods: { type: 'tail' }
                }],
                content: ''
            },
            // варнинг на тему, что выбраны все регионы
            {
                elem: 'all-regions-warning',
                elemMods: { active: 'yes' },
                content: [{
                    block: 'icon',
                    mods: { 'size-13': 'alert' }
                },
                    '&nbsp;',
                    iget2(
                        'b-potential-report-region',
                        'proverte-nastroyki-geotargetinga-tekushchiy',
                        'Проверьте настройки геотаргетинга. Текущий геотаргетинг: Весь&nbsp;мир'
                    )
                ]
            }
        ];
    }),

    elem('text').tag()('span')
);
