BEM.DOM.decl('b-potential-report-region', {

    STORE_FLAG_PREFIX: 'b-potential-report-region',

    onSetMod: {

        js: function() {
            this.model = BEM.MODEL
                .create({ name: 'm-geo-regions', id: this.params.regionsModelId })
                .on('geo', 'change', this.onGeoChange, this)
                .on('geoText', 'change', this.onGeoTextChanged, this);

            this._fromRegion = this.findBlockOn('from-campaign', 'button');
            this._storeFlag = this.STORE_FLAG_PREFIX + ':' + this.params.regionsModelId;

            this.findBlockOn('from-campaign', 'button').on('release', function() {
                this.trigger('request-data');
            }, this);

            this._request = BEM.create('i-request_type_ajax', {
                url: this.params.url,
                cache: false,
                type: 'GET',
                dataType: 'json'
            });

            this.confirm = BEM.blocks['b-confirm'];
        },

        disabled: function(modName, modVal) {
            this.findBlockInside('button').setMod('disabled', modVal);

            this._fromRegion
                .setMod('disabled', modVal === 'yes' || this.getMod('disabled-from-campaign') === 'yes' ? 'yes' : '');

            if (modVal === 'yes')
                this.findBlockInside('b-outboard-controls').decline(true);
        },

        'disabled-from-campaign': function(modName, modVal) {
            this._fromRegion
                .setMod('disabled', modVal === 'yes' || this.getMod('disabled') === 'yes' ? 'yes' : '');
        }
    },

    /**
     * Обработчик изменения поля geo модели
     * @param {Event} e событие
     * @param {Object} data данные
     * @param {String|Number} data.value номера регионов или 0 если все регионы
     */
    onGeoChange: function(e, data) {

        this.setMod(
            this.elem('all-regions-warning'),
            'active',
            this.isAllWorldGeo(data.value) ? 'yes' : '');
    },

    /**
     * Обработчик изменения поля geoText модели регионов
     * @param {Event} event событие
     * @param {Object} data данные
     * @param {String} data.value выбранные регионы
     */
    onGeoTextChanged: function(event, data) {
        this
            .elem('selected-regions')
            .text(data.value);
    },

    /**
     * Обработчик ответа сервера на запрос получения регионов из номеров кампаний или логинов
     * @param {Object} response
     */
    onServerGeoResponse: function(response) {
        if (response.errors) {

            BEM.blocks['b-confirm'].alert(response.errors.map(function(e) {
                return u.escapeHTML(e);
            }).join('<br/>'));

            return;
        }

        this.model
            .update(response)
            .fix();
    },

    /**
     * Обработчик серверной ошибки (с кодом не 200)
     */
    _onServerError: function() {
        this.confirm.alert(iget2('b-potential-report-region', 'servernaya-oshibka-povtorite-nemnogo', 'Серверная ошибка, повторите немного позже'));
    },

    /**
     * Устанавливает регион из кампании
     * @param {String} type тип [cids|logins]
     * @param {String[]} datap номера кампаний или логины
     */
    setRegionByData: function(type, datap) {
        var data = datap.join(),
            requestData;

        // если данных нет в полях, то ничего не делаем
        if (!data) return;

        requestData = { cmd: 'getCampsGeo' };

        requestData[type] = data;

        this._request.get(
            requestData,
            this.onServerGeoResponse.bind(this),
            this._onServerError.bind(this));
    },

    /**
     * Возвращает строку содержащую инфу о регионах (айдишники)
     * @returns {String}
     */
    getGeo: function() {
        return this.model.get('geo');
    },

    /**
     * Проверка на то, представляет ли geo весь мир (true если представляет)
     * @param {String|Number} geo номера регионов
     * @returns {Boolean}
     */
    isAllWorldGeo: function(geo) {
        return geo == 0 || geo === '225,166,111,183,241,10002,10003,138';
    },

    /**
     * Очищает регионы и ставит весь мир
     */
    clear: function() {
        this.model
            .update({
                geo: 0,
                geoText: ''
            })
            .fix();
    },

    /**
     * Сохраняет данные в хранилище
     */
    store: function() {
        u.store.set(this._storeFlag, this.model.toJSON());
    },

    /**
     * Восстанавливает данные из хранилища
     */
    restore: function() {
        this.model
            .update(u.store.get(this._storeFlag))
            .fix();
    }
});
