block('b-potential-reports-list').elem('content')(

    content()(function() {
        return iget2('b-potential-reports-list', 'net-gotovyh-otchetov', 'Нет готовых отчетов');
    }),

    match(function() {
        return !!(this.ctx.reports && this.ctx.reports.length);
    }).content()(function() {
        var ulogin = this.ctx.ulogin,
            lang = this.ctx.lang,
            url = u.parseUrl(this.ctx.url),
            sortBy = this.ctx.sortBy || 'create_time',
            reverse = this.ctx.reverse,
            currentPage = this.ctx.currentPage,
            totalPages = this.ctx.totalPages,

            /**
             * Генерирует функцию для использования в качестве transformData
             * @param {String} field имя поля в строке
             * @returns {Function}
             */
            escapeTransform = function(field) {
                return function(row) {
                    return row[field] ? u.escapeHTML(row[field]) : '';
                }
            },

            /**
             * Генерирует заголовок столбца, который можно сортировать
             * @param {String} sortKey поле для сортировки
             * @param {String} title заголовок для отображения
             * @returns {Object}
             */
            getTitleLink = function(sortKey, title) {
                return {
                    block: 'link',
                    mix: [{
                        block: 'b-potential-reports-list',
                        elem: 'sort',
                        js: { sortBy: sortKey }
                    }],
                    mods: {
                        pseudo: 'yes',
                        theme: 'without-border'
                    },
                    content: [
                        title,
                        sortBy === sortKey && ('&nbsp;' + (reverse ? '↓' : '↑'))
                    ]
                }
            };

        return [{
            block: 'b-data-table',
            mix: [{
                block: 'b-style-table',
                mods: {
                    theme: 'gray-list',
                    size: 'm'
                }
            }],
            columns: [{
                key: 'create_time',
                title: getTitleLink('create_time', iget2('b-potential-reports-list', 'sozdan', 'Создан'))
            }, {
                key: 'data',
                title: iget2('b-potential-reports-list', 'dannye', 'Данные'),
                transformData: function(row) {
                    return iget2('b-potential-reports-list', 'raschet-potenciala-klienta', 'Расчёт потенциала клиента');
                }
            }, {
                key: 'client_name',
                title: iget2('b-potential-reports-list', 'klient', 'Клиент'),
                transformData: escapeTransform('client_name')
            }, {
                key: 'category_name',
                title: iget2('b-potential-reports-list', 'kategoriya', 'Категория'),
                transformData: escapeTransform('category_name')
            }, {
                key: 'status',
                title: iget2('b-potential-reports-list', 'deystviya', 'Действия'),
                transformData: function(report) {
                    var statusIs = function() {
                        return Array.prototype.indexOf.call(arguments, report.status) > -1;
                    };

                    return [
                        statusIs('processing', 'new') && iget2('b-potential-reports-list', 'v-processe-podgotovki', 'В процессе подготовки...'),

                        statusIs('failed') && iget2('b-potential-reports-list', 'oshibka-generacii', 'Ошибка генерации') + '<br/>',

                        statusIs('failed') && {
                            block: 'link',
                            mods: { pseudo: 'yes' },
                            js: { action: 'repair' },
                            url: u.formatUrl({
                                protocol: url.protocol,
                                host: url.host,
                                path: url.path,
                                query: {
                                    cmd: 'repairClientPotentialReport',
                                    rid: report.id
                                }
                            }),
                            content: iget2('b-potential-reports-list', 'povtorit', 'повторить')
                        },

                        statusIs('ready') && {
                            block: 'link',
                            mods: { pseudo: 'yes' },
                            js: { action: 'download' },
                            url: u.formatUrl({
                                protocol: url.protocol,
                                host: url.host,
                                path: '/registered/' + report.report_filename,
                                query: {
                                    cmd: 'loadClientPotentialReport',
                                    rid: report.id
                                }
                            }),
                            content: iget2('b-potential-reports-list', 'skachat', 'скачать')
                        },
                        ' ',
                        statusIs('failed', 'ready') && {
                            block: 'link',
                            mods: {
                                pseudo: 'yes',
                                'need-confirm': 'yes'
                            },
                            js: { action: 'delete' },
                            confirm: iget2('b-potential-reports-list', 'vy-uvereny-chto-hotite', 'Вы уверены, что хотите удалить отчет?'),
                            url: u.formatUrl({
                                protocol: url.protocol,
                                host: url.host,
                                path: url.path,
                                query: {
                                    cmd: 'delClientPotentialReport',
                                    rid: report.id
                                }
                            }),
                            content: iget2('b-potential-reports-list', 'udalit-101', 'удалить')
                        }
                    ];
                }
            }],
            mixes: {
                row: [{
                    block: 'b-style-table',
                    elem: 'row'
                }],
                headerRow: [
                    {
                        block: 'b-style-table',
                        elem: 'head'
                    },
                    {
                        block: 'b-potential-reports-list',
                        elem: 'head'
                    }
                ],
                cell: [
                    {
                        block: 'b-style-table',
                        elem: 'cell'
                    },
                    {
                        block: 'b-potential-reports-list',
                        elem: 'cell'
                    }
                ],
                headerCell: function(key) {

                    return [
                        {
                            block: 'b-style-table',
                            elem: 'cell'
                        }, {
                            block: 'b-potential-reports-list',
                            elem: key.replace('_', '-') + '-column'
                        }
                    ];
                }
            },
            rows: this.ctx.reports || []
        },
            totalPages > 1 && {
                block: 'b-pager2',
                mix: [{
                    block: 'b-potential-reports-list',
                    elem: 'pager'
                }],
                mods: { type: 'js' },
                startFrom: 1,
                currentPage: currentPage,
                totalPages: totalPages,
                content: [{
                    elem: 'pages'
                }]
            }
        ];
    })
);
