BEM.DOM.decl('b-potential-reports-list', {

    // адрес контроллера для запроса списка
    CMD: 'listClientPotentialReport',
    // время между автоматическими догрузками списка в миллисекундах
    UPDATE_TIMEOUT_MS: 1000 * 60 * 2,

    // номер таймера автозагрузки
    _timer: null,

    _sortBy: 'create_time',

    onSetMod: {

        js: function() {
            this._reportsRequest = BEM.create('i-request_type_ajax', {
                url: this.params.url,
                cache: false,
                dataType: 'json'
            });

            this._reverse = true;
            this._page = 1;

            this.update();

            // динамически подписываемся
            BEM.blocks['b-pager2'].on(this.domElem, 'change', function(e, data) {
                this._page = data.currentVal;
                this.update();
            }, this);

            BEM.DOM.blocks['link'].on(this.elem('content-wrap'), 'click', this.onLinkClick, this);

            this._timer = setTimeout(this.update.bind(this), this.UPDATE_TIMEOUT_MS);
        }

    },

    /**
     * Обработчик запроса списка
     * @param {Object} result данные от сервера
     */
    _onServerSuccess: function(result) {
        result = result || {};

        this._render(result.reports, {
            current: result.page,
            total: +result.pages_num
        });
    },

    /**
     * Обработчик ошибки от сервера
     */
    _onServerError: function() {
        BEM.DOM.update(
            this.elem('content-wrap'),
            iget2('b-potential-reports-list', 'servernaya-oshibka-ne-udaetsya', 'Серверная ошибка, не удается запросить список'),
            this.delMod.bind(this, 'loading'));
    },

    /**
     * Обработчик клика по кнопке действия
     * @param {Event} event событие
     * @param {Object} event.block ссылка
     */
    onLinkClick: function(event) {
        var action = event.block.params.action;

        if (action === 'repair' || action === 'delete') {
            this.setMod('loading', 'yes');
            this._sendAction(event.block.domElem.attr('href'));

        } else if (action === 'download') {
            window.open(event.block.domElem.attr('href'), '_self');
        }
    },

    /**
     * Делает запрос на выполнение некоего действия по урлу.
     * Перезагружает список и показывает ошибки если нужно
     * @param {String} href адрес действия
     * @private
     */
    _sendAction: function(href) {
        BEM
            // создаем и отправляем запрос со ссылкой указанной на кнопке действия
            .create('i-request_type_ajax', {
                url: href,
                cache: false,
                dataType: 'json'
            })
            .get(
                {},
                function(result) {
                    if (result.errors && result.errors.length) {
                        BEM.blocks['b-confirm']
                            .alert(result.errors.join('<br/>'));

                        this.delMod('loading');

                        return;
                    }

                    this.update();
                },
                function() {
                    BEM.blocks['b-confirm']
                        .alert(iget2('b-potential-reports-list', 'oshibka-servera-poprobuyte-cherez', 'Ошибка сервера. Попробуйте через несколько минут'));

                    this.delMod('loading');
                },
                { callbackCtx: this });
    },

    /**
     * Обновляет таблицу готовых отчетов
     */
    update: function() {
        var pager = this.findBlockOn('pager', 'b-pager2');

        pager && pager.setMod('disabled', 'yes');
        this.setMod('loading', 'yes');

        this._reportsRequest.get(
            {
                cmd: this.CMD,
                ulogin: this.params.ulogin,
                sort: this._sortBy,
                sort_reverse: +this._reverse,
                page: this._page
            },
            this._onServerSuccess,
            this._onServerError,
            { callbackCtx: this });

        clearTimeout(this._timer);
        this._timer = setTimeout(this.update.bind(this), this.UPDATE_TIMEOUT_MS);
    },

    /**
     * Шаблонизирует таблицу готовых отчетов
     * @param {Array} [reports]
     * @param {Object} [pagesInfo]
     * @private
     */
    _render: function(reports, pagesInfo) {
        var content = BEMHTML.apply({
            block: 'b-potential-reports-list',
            elem: 'content',
            reports: reports || [],
            ulogin: this.params.ulogin,
            lang: this.params.lang,
            url: this.params.url,
            sortBy: this._sortBy,
            reverse: this._reverse,
            currentPage: pagesInfo.current,
            totalPages: pagesInfo.total
        });

        BEM.DOM.update(this.elem('content-wrap'), content, function() {
            this.delMod('loading');

            this.findBlocksOn(this.findElem('sort'), 'link').forEach(function(sortLink) {
                sortLink.on('click', function(e) {
                    var sortBy = this.elemParams(sortLink.domElem).sortBy;

                    this.sort(sortBy, sortBy === this._sortBy ? !this._reverse : true);
                }, this);
            }, this);
        }.bind(this));
    },

    /**
     * Сортирует таблицу готовых отчетов
     * @param {String} sortBy
     * @param {Boolean} reverse
     */
    sort: function(sortBy, reverse) {
        this._sortBy = sortBy;
        this._reverse = reverse;

        this.update();
    }

});
