BEM.DOM.decl('b-price-control', {
    onSetMod: {
        js: function() {
            this._model = BEM.MODEL.getOrCreate(this.params.modelParams).get('banner_price');
            this._subscriptionManager = BEM.create('i-subscription-manager');

            if (u._.get(window, 'dna.components.BannersPriceEditor')) {
                this._subscriptionManager.on(this._model, 'change', this._onModelChange, this);
                this.delMod('loading');
                this._renderDna();
            }
        }
    },

    _onModelChange: function() {
        this.trigger('change');
        this._renderDna();
    },

    _onChange: function(field, value) {
        this._model.set(field, value);
    },

    /**
     * Render DNA root component
     */
    _renderDna: function() {
        var dna = window.dna,
            bannerPrice = this._model.toJSON(),
            dnaRootComponent = dna.reactCreateElement(
                dna.components.BannersPriceEditor,
                {
                    bannerPrice: {
                        price: {
                            text: bannerPrice.price,
                            valid: true
                        },
                        priceOld: {
                            text: bannerPrice.priceOld,
                            valid: true
                        },
                        prefix: bannerPrice.prefix,
                        currency: bannerPrice.currency
                    },
                    size: 's',
                    dilimiterPoint: true,
                    onChange: this._onChange.bind(this)
                },
                null
            );

        dna.reactDOMRender(dnaRootComponent, this.domElem.get(0));
    },

    destruct: function() {
        this._subscriptionManager.dispose();
        this._subscriptionManager.destruct();

        return this.__base.apply(this, arguments);
    }
});
