block('b-prices-constructor').elem('context-scope')(
    replace()(function() {
        var ctx = this.ctx,
            contextScope = ctx.savedData.context_scope;

        return {
            block: 'select',
            name: this.namesMap.context_scope,
            mods: { disabled: ctx.savedData.is_context_disabled ? 'yes' : '' },
            mix: [
                {
                    block: 'b-prices-constructor',
                    elem: 'context-scope-select'
                },
                {
                    block: 'b-prices-constructor',
                    elem: 'form-control'
                },
                {
                    block: 'b-prices-constructor',
                    elem: 'model-field',
                    js: [
                        {
                            block: 'select',
                            name: 'is_context_disabled',
                            modName: 'disabled',
                            type: 'mod'
                        },
                        {
                            name: 'context_scope',
                            type: 'select'
                        }
                    ]
                }
            ],
            content: [
                {
                    block: 'button',
                    mix: {
                        block: 'b-prices-constructor',
                        elem: 'context-scope-select-btn'
                    }
                },
                {
                    elem: 'control',
                    content: [100, 90, 80, 70, 60, 50, 40, 30, 20, 10].map(function(value) {
                        var text = value + '%',
                            opt = {
                                block: 'select',
                                elem: 'option',
                                attrs: { value: value },
                                content: text
                            };

                        if (contextScope == value) {
                            opt.attrs.selected = 'selected';
                        }

                        return opt;
                    }, this)
                }
            ]
        };
    })
);
