block('b-prices-constructor').elem('price-base')(
    replace()(function() {
        var ctx = this.ctx,
            savedData = ctx.savedData,
            priceBaseSearch = savedData.position_ctr_correction,
            options = [
                { value: 'max', text: iget2('b-prices-constructor', 'max', 'макс.') },
                { value: '100', text: '100' },
                { value: '95', text: '95' },
                { value: '90', text: '90' },
                { value: '85', text: '85' },
                { value: '80', text: '80' },
                { value: '75', text: '75' },
                { value: '65', text: '65' },
                { value: '15', text: '15' },
                { value: '5', text: '5' }
            ];

        return {
            block: 'select',
            name: this.namesMap.position_ctr_correction,
            mods: { disabled: savedData.is_search_disabled ? 'yes' : '' },
            mix: [
                {
                    block: 'b-prices-constructor',
                    elem: 'price-base-select'
                },
                {
                    block: 'b-prices-constructor',
                    elem: 'form-control'
                },
                {
                    block: 'b-prices-constructor',
                    elem: 'model-field',
                    js: [
                        {
                            name: 'is_search_disabled',
                            modName: 'disabled',
                            type: 'mod',
                            block: 'select'
                        },
                        {
                            name: 'position_ctr_correction',
                            type: 'select'
                        }
                    ]
                }
            ],
            content: [
                {
                    block: 'button',
                    content: options.filter(function(option) {
                        return option.value === priceBaseSearch;
                    })[0].text,
                    mix: {
                        block: 'b-prices-constructor',
                        elem: 'price-base-select-btn'
                    }
                },
                {
                    elem: 'control',
                    content: options.map(function(option) {
                        var attrs = {
                            value: option.value
                        };

                        if (option.value == priceBaseSearch) {
                            attrs.selected = 'selected';
                        }

                        return {
                            elem: 'option',
                            attrs: attrs,
                            content: option.text
                        };
                    }, this)
                }
            ]
        };
    })
);
