block('b-prices-constructor').elem('price')(
    content()(function() {
        var ctx = this.ctx,
            savedData = ctx.savedData,
            platform = ctx.forPlatform;

        return [
            {
                block: 'input',
                value: u.numberFormatter.format(savedData['price_' + platform]),
                mods: {
                    clear: 'no',
                    disabled: savedData['is_' + platform + '_disabled'] ? 'yes' : ''
                },
                content: {
                    elem: 'control',
                    controlAttrs: { name: this.namesMap['price_' + platform] }
                },
                mix: [
                    {
                        block: 'b-prices-constructor',
                        elem: 'price-input'
                    },
                    {
                        block: 'b-prices-constructor',
                        elem: 'form-control'
                    },
                    {
                        block: 'b-prices-constructor',
                        elem: 'model-field',
                        js: [
                            {
                                name: 'is_' + platform + '_disabled',
                                modName: 'disabled',
                                type: 'mod',
                                block: 'input'
                            },
                            {
                                name: 'price_' + platform,
                                type: 'formatted-input'
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'currency-name',
                tag: 'span',
                content: ctx.currencyName
            }
        ];
    }),

    elemMod('type', 'performance')(
        elemMod('performance', 'avg-cpa').content()(''),

        elemMod('performance', 'avg-cpc').content()(''),

        content()(function() {
            var ctx = this.ctx;

            return [
                applyNext(),
                {
                    block: 'input',
                    value: u.numberFormatter.format(ctx.savedData['price_performance']),
                    mods: { clear: 'no' },
                    content: { elem: 'control' },
                    mix: [
                        {
                            block: 'b-prices-constructor',
                            elem: 'price-input'
                        },
                        {
                            block: 'b-prices-constructor',
                            elem: 'form-control'
                        },
                        {
                            block: 'b-prices-constructor',
                            elem: 'model-field',
                            js: {
                                name: 'price_performance',
                                type: 'formatted-input'
                            }
                        }
                    ]
                },
                {
                    elem: 'currency-name',
                    tag: 'span',
                    content: ctx.currencyName
                }
            ];
        })
    )
);
