block('b-prices-constructor').elem('proc')(
    replace()(function() {
        var ctx = this.ctx,
            forPlatform = ctx.forPlatform,
            disabledName = 'is_' + forPlatform + '_disabled',
            fieldName = 'proc_' + forPlatform,
            savedData = ctx.savedData,
            isDisabled = savedData[disabledName];

        return {
            block: 'input',
            mods: {
                size: 's',
                clear: 'no',
                disabled: isDisabled ? 'yes' : ''
            },
            content: {
                elem: 'control',
                attrs: {
                    value: savedData[fieldName],
                    name: this.namesMap[fieldName]
                }
            },
            mix: [
                {
                    block: 'b-prices-constructor',
                    elem: 'proc-input'
                },
                {
                    block: 'b-prices-constructor',
                    elem: 'form-control'
                },
                {
                    block: 'b-prices-constructor',
                    elem: 'model-field',
                    js: [
                        {
                            name: fieldName,
                            type: 'input'
                        },
                        {
                            name: disabledName,
                            modName: 'disabled',
                            type: 'mod',
                            block: 'input'
                        }
                    ]
                }
            ]
        };
    })
);
