BEM.MODEL.decl({ model: 'b-prices-constructor_type_cpm-yndx-frontpage', baseModel: 'b-prices-constructor' }, {
    price_context: {
        type: 'blank-number',
        validation: {
            rules: {
                required: { text: iget2('b-prices-constructor', 'bid-required', 'Неверно указана ставка') },
                gte: function() {
                    var currency = this.get('currency');

                    return {
                        value: u.currencies.getConst(currency, 'MAX_CPM_PRICE'),
                        text: iget2('b-prices-constructor', 'stavka-ne-mozhet-byt-bolshe', 'Cтавка не может быть больше {price}', {
                            price: u.currencies.formatConst(currency, 'MAX_CPM_PRICE'),
                            context: 'price - 10 руб.'
                        }),
                        needToValidate: function(value) {
                            return typeof value === 'number';
                        }
                    };
                },
                lte: function() {
                    var currencyName = this.get('currency'),
                        campModel = this.getParentModel(),
                        cpmYndxFrontpageMinPrice = BEM.blocks['cpm-yndx-frontpage-min-price'].getMinPrice(
                            [campModel.get('cid')],
                            currencyName
                        );

                    return {
                        value: cpmYndxFrontpageMinPrice,
                        text: iget2('b-prices-constructor', 'bid-lte-error', 'Ставка не может быть меньше {price}', {
                            price: u.currencies.formatSum(currencyName, cpmYndxFrontpageMinPrice),
                            context: 'price - 10 руб.'
                        }),
                        needToValidate: function(value) {
                            return typeof value === 'number';
                        }
                    };
                }
            }
        }
    }
});
