block('b-prices-constructor').mod('type', 'performance')(

    mod('performance', 'avg-cpc').mode('performance-type')(function() {
        return u.performance.TYPE.CPC;
    }),
    mod('performance', 'avg-cpa').mode('performance-type')(function() {
        return u.performance.TYPE.CPA;
    }),

    def()(function() {
        var defaultData = {
                performance_type: apply('performance-type'),
                is_performance_disabled: false,
                price_performance: this.ctx.minPay
            },
            savedData = u._.extend(
                defaultData,
                u._.pick(this.ctx.savedData || {}, ['price_performance']), {
                    performance_type: apply('performance-type')
                });

        savedData.currency = this.ctx.currency || 'YND_FIXED';

        return applyNext({
            'ctx.savedData': savedData,
            currencyName: this.ctx.currencyName,
            defaultData: defaultData
        });
    }),

    content()(function() {
        return {
            elem: 'form',
            elemMods: {
                type: this.mods.type,
                performance: this.mods.performance
            },
            savedData: this.ctx.savedData
        };
    })
);
