block('b-prices-constructor')(
    /**
     * Параметры:
     * showBothPlatforms - показываем одновременно "размещение на поиске" и "размещение на контексте",
     * только для стратегии "отдельное размещение"  - может быть true или false
     * formType - тип конструктора - бывает общий (для обычных стратегий), для поиска на отдельном размещении,
     * для контекста на отдельном размещении. Принимает значения 'common', 'search' и 'context'
     *
     **/
    match(function() { return !this.defaultData; }).def()(function() {
        var savedData = this.ctx.savedData || {},
            strategy = this.ctx.strategy,
            isDiffPlace = strategy.name == 'different_places',
            isSearchStop = strategy.search.name == 'stop',
            defaultData = apply('constructor-data');

        for (var name in defaultData) {
            if (savedData[name] === undefined) savedData[name] = defaultData[name];
        }

        this.ctx.isOfflineViewMode = this.ctx.viewMode == 'offline';

        this.ctx.showBothPlatforms = this.ctx.showBothPlatforms && isDiffPlace && !isSearchStop;

        //у нас не могут быть задизейблены одновременно и поиск, и контекст
        if (!savedData.search_toggle && !savedData.context_toggle) {
            savedData.search_toggle = true;
            savedData.context_toggle = true;
        }

        if (isSearchStop) {
            savedData.platform = 'context';
            savedData.context_toggle = true;
            savedData.search_toggle = false;
        } else if (isDiffPlace) {
            savedData.platform = savedData.platform || 'search';

            savedData.context_toggle = this.ctx.showBothPlatforms ?
                savedData.context_toggle :
                savedData.platform == 'context';

            savedData.search_toggle = this.ctx.showBothPlatforms ?
                savedData.search_toggle :
                savedData.platform == 'search';
        } else {
            savedData.platform = 'search';
            savedData.context_toggle = false;
            savedData.search_toggle = true;
        }

        //is_search_disabled и is_context_disabled не могут быть сохранены - они всегда вычисляются
        savedData.is_search_disabled = savedData.is_disabled || !savedData.search_toggle;
        savedData.is_context_disabled = savedData.is_disabled || !savedData.context_toggle;

        savedData.currency = this.ctx.currency || 'YND_FIXED';

        return applyNext({
            'mods.offline': this.ctx.isOfflineViewMode ? 'yes' : '',
            'mods.platform': this.ctx.strategy.name != 'different_places' ? savedData.platform : '',
            'mods.search-disabled': savedData.is_search_disabled ? 'yes' : '',
            'mods.context-disabled': savedData.is_context_disabled ? 'yes' : '',
            'ctx.savedData': savedData,
            currencyName: this.ctx.currencyName,
            namesMap: this.ctx.namesMap || {},
            defaultData: defaultData
        });
    }),

    mode('constructor-data')(function() {
        return {
            position_ctr_correction: '100',
            context_scope: '100',
            proc_search: 30,
            proc_context: 30,
            price_search: this.ctx.minPay,
            price_context: this.ctx.minPay
        }
    }),

    js()(function() {
        return {
            modelParams: u._.extend({}, this.ctx.modelParams, {
                name: 'b-prices-constructor',
                data: this.ctx.savedData
            }),
            defaultData: this.defaultData,
            id: this.ctx.isOfflineViewMode ? 'offline' : 'online',
            strategy: this.ctx.strategy
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            isSimple = ctx.isSimple,
            savedData = ctx.savedData,
            isOfflineViewMode = ctx.isOfflineViewMode;

        switch (ctx.formType) {
            case 'csv':
                return {
                    elem: 'form',
                    elemMods: { type: 'csv' },
                    savedData: savedData
                };

            case 'common':
                return {
                    elem: 'form',
                    elemMods: { type: isSimple ? 'common-simple' : 'common-wizard' },
                    savedData: savedData,
                    isOfflineViewMode: isOfflineViewMode
                };

            case 'search':
                return {
                    elem: 'form',
                    elemMods: {
                        type: isSimple ? 'search-simple' : 'search-wizard'
                    },
                    mix: [{
                        block: 'b-prices-constructor',
                        elem: 'search'
                    }],
                    savedData: savedData,
                    isOfflineViewMode: isOfflineViewMode,
                    showToggle: ctx.showBothPlatforms
                };

            case 'context':
                return {
                    elem: 'form',
                    elemMods: { type: this.ctx.isSimple ? 'context-simple' : 'context-wizard' },
                    mix: [{
                        block: 'b-prices-constructor',
                        elem: 'context'
                    }],
                    savedData: savedData,
                    isOfflineViewMode: isOfflineViewMode,
                    showToggle: ctx.strategy.search.name != 'stop' && ctx.showBothPlatforms
                };

            default:
                throw new Error('Unsupported formType for prices constructor');
        }
    })
);
