BEM.DOM.decl({ block: 'b-prices-constructor', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this.bindModelEvents({ isBind: true });
        }
    },

    /**
     * Устанавливает дефолтные значения конструктора ставок
     * @returns {BEM}
     */
    setDefault: function() {
        this.model.update(this.params.defaultData).fix();

        return this;
    },

    /**
     * Возвращает данные из полей конструктора ставок
     * @returns {BEM}
     */
    getData: function() {
        return this.model.toJSON();
    },

    /**
     * Включаем валидацию полей на blur и подсветку ошибок
     * @returns {*}
     */
    highlightErrorInputs: function() {
        ['price_search', 'proc_search'].forEach(function(name) {
            var input = this.getFieldBlock(name).input;

            input.on('blur', this.validate, this);

            this.model.on('validated', function(e, data) {
                input.setMod(
                    'error',
                    data.valid || data.errorFields && data.errorFields.indexOf(name) == -1 ? '' : 'yes'
                );
                this.trigger('validated', { valid: data.valid });
            }, this);
        }, this);

        return this;
    },

    /**
     * Валидирует конструктор ставок
     * @returns {Object}
     */
    validate: function() {
        return this.model.validate();
    },

    /**
     * Делает конструктор ставок недоступным на поиске/контексте
     * @param {'search'|'context'} place
     * @param {Boolean} isDisabled
     * @returns {BEM}
     */
    disablePlace: function(place, isDisabled) {
        this.model.set(place == 'search' ? 'is_search_disabled' : 'is_context_disabled', isDisabled);

        return this;
    },

    /**
     * Переключает модель конструктора в простой режим
     * @param {Boolean} isSimple
     * @returns {BEM}
     */
    setSimple: function(isSimple) {
        this.model.set('is_simple', isSimple);

        return this;
    },

    isSearchPlace: function() {
        return !this.model.get('is_search_disabled');
    },

    isContextPlace: function() {
        return !this.model.get('is_context_disabled');
    },

    /**
     * Привязываем/отвязываем события
     * @param {Object} data
     * @param {Boolean} data.isBind
     * @returns {BEM}
     */
    bindModelEvents: function(data) {
        var actionName = data.isBind ? 'on' : 'un';

        this.model[actionName]('platform', 'change', this._onPlatformChanged, this);
        this.model[actionName]('context_toggle search_toggle', 'change', this._onPlatformToggleChanged, this);
        this.model[actionName]('is_context_disabled is_search_disabled', 'change', this._onPlatformDisabled, this);

        return this;
    },

    /**
    * Изменилось значение "задизейбленно на поиске/контексте"
    * @param {Object} e
    * @param {Object} data
    * @param {String} data.value
    * @param {String} data.field
    * @returns {BEM}
    * @private
    */
    _onPlatformDisabled: function(e, data) {
        this.setMod(
            data.field == 'is_search_disabled' ?
                'search-disabled' :
                'context-disabled',
            data.value ? 'yes' : ''
        );

        return this;
    },

    /**
     * Изменилось значение чекбокса "на поиске/контексте"
     * @param {Object} e
     * @param {Object} data
     * @param {String} data.value
     * @param {String} data.field
     * @returns {BEM}
     * @private
     */
    _onPlatformToggleChanged: function(e, data) {
        var otherName = data.field == 'search_toggle' ? 'context_toggle' : 'search_toggle';

        if (!this.model.get(otherName) && !data.value) {
            this.model.set(otherName, true);
        }

        this.model.update({
            is_search_disabled: !this.model.get('search_toggle'),
            is_context_disabled: !this.model.get('context_toggle')
        });

        return this;
    },

    /**
     * Отписка от ненужных событий
     * @returns {BEM}
     */
    destruct: function() {
        this.bindModelEvents({ isBind: false });

        return this;
    },

    /**
     * Изменилось значение платформы
     * @param {Object} e
     * @param {Object} data
     * @param {String} data.value
     * @param {String} data.field
     * @returns {BEM}
     * @private
     */
    _onPlatformChanged: function(e, data) {
        this.setMod('platform', data.value);

        this.model.update({
            is_search_disabled: data.value != 'search',
            is_context_disabled: data.value != 'context'
        });

        this.trigger('change-size');

        return this;
    }
});
