BEM.MODEL.decl('b-prices-constructor', {
    price_performance: {
        type: 'blank-number',
        validation: {
            rules: {
                required: { text: iget2('b-prices-constructor', 'bid-required', 'Неверно указана ставка') },
                gte: function() { return this.getMaxPriceRule('performance') },
                lte: function() { return this.getMinPriceRule('performance') }
            },
            needToValidate: function() {
                return !this.get('is_performance_disabled');
            }
        }
    },

    //ставка на контексте
    price_context: {
        type: 'blank-number',
        validation: {
            rules: {
                required: { text: iget2('b-prices-constructor', 'bid-required', 'Неверно указана ставка') },
                gte: function() { return this.getMaxPriceRule('context') },
                lte: function() { return this.getMinPriceRule('context') }
            },
            needToValidate: function() {
                return this.get('is_performance_disabled') && !this.get('is_context_disabled');
            }
        }
    },

    //ставка на поиске
    price_search: {
        type: 'blank-number',
        validation: {
            rules: {
                required: { text: iget2('b-prices-constructor', 'bid-required', 'Неверно указана ставка') },
                gte: function() { return this.getMaxPriceRule('search') },
                lte: function() { return this.getMinPriceRule('search') }
            },
            needToValidate: function() {
                return this.get('is_performance_disabled') && !this.get('is_search_disabled');
            }
        }
    },

    //значение переключателя "на поиске/контексте/везде"
    platform: { type: 'enum', enum: ['search', 'context', 'both', ''], default: 'search' },

    // объем трафика в % на поиске
    position_ctr_correction: {
        type: 'enum',
        enum: ['max', '100', '95', '90', '85', '80', '75', '65', '15', '5'],
        default: '100'
    },

    //% охвата аудитории
    context_scope: {
        type: 'enum',
        enum: ['100', '90', '80', '70', '60', '50', '40', '30', '20', '10'],
        default: '100'
    },

    // тип оптимизации: кликам/конверсия
    performance_type: { type: 'enum', enum: u.performance.getTypes(), default: u.performance.TYPE.CPC },

    //+n % от ставки на поиске
    proc_search: {
        type: 'blank-number',
        precision: 0,
        validation: {
            rules: {
                required: { text: iget2('b-prices-constructor', 'neverno-ukazany-procenty-na', 'Неверно указаны проценты на поиске') },
                gte: function() { return this.getMaxPercRule('search') },
                lte: function() { return this.getMinPercRule('search') }
            },
            needToValidate: function() {
                return this.get('is_performance_disabled') && !this.get('is_simple') && !this.get('is_search_disabled');
            }
        }
    },

    //+n % от ставки на контексте
    proc_context: {
        type: 'blank-number',
        precision: 0,
        validation: {
            rules: {
                required: { text: iget2('b-prices-constructor', 'neverno-ukazany-procenty-v', 'Неверно указаны проценты в сетях') },
                gte: function() { return this.getMaxPercRule('context') },
                lte: function() { return this.getMinPercRule('context') }
            },
            needToValidate: function() {
                return this.get('is_performance_disabled') && !this.get('is_simple') &&
                    !this.get('is_context_disabled');
            }
        }
    },

    //чекбокс "для фраз"
    phrases_context: 'boolean',
    //чекбокс "для условий ретаргетинга"
    retargetings_context: 'boolean',
    //конструктор ставок недоступен
    is_disabled: 'boolean',
    //недоступно редактирование ставки на поиске
    is_search_disabled: 'boolean',
    //недоступно редактирование ставки на контексте
    is_context_disabled: 'boolean',
    //недоступно редактирование ставки на контексте
    is_performance_disabled: {
        type: 'boolean',
        default: true
    },
    //чекбокс "контекст" в отдельном  размещении
    context_toggle: 'boolean',
    //чекбокс "поиск" в отдельном  размещении
    search_toggle: 'boolean',
    //показываем сокращенный конструктор ставок
    is_simple: 'boolean',

    //текущая валюта конструктора ставок
    currency: 'string'
}, {
    getMinPriceRule: function(platform) {
        var currency = this.get('currency');

        return ({
            performance: {
                value: u.currencies.getConst(currency, 'MIN_CPC_CPA_PERFORMANCE'),
                text: iget2('b-prices-constructor', 'bid-lte-error', 'Ставка не может быть меньше {price}', {
                    price: u.currencies.formatConst(currency, 'MIN_CPC_CPA_PERFORMANCE')
                })
            },
            search: {
                value: u.currencies.getConst(currency, 'MIN_PRICE'),
                text: iget2('b-prices-constructor', 'bid-search-lte-error', 'Ставка на поиске не может быть меньше {price}', {
                    price: u.currencies.formatConst(currency, 'MIN_PRICE')
                })
            },
            context: {
                value: u.currencies.getConst(currency, 'MIN_PRICE'),
                text: iget2('b-prices-constructor', 'bid-context-lte-error', 'Ставка в сетях не может быть меньше {price}', {
                    price: u.currencies.formatConst(currency, 'MIN_PRICE')
                })
            }
        })[platform];
    },

    getMaxPriceRule: function(platform) {
        var currency = this.get('currency'),
            formattedValue = u.currencies.formatConst(currency, 'MAX_PRICE');

        return {
            value: u.currencies.getConst(currency, 'MAX_PRICE'),
            text: ({
                performance: iget2('b-prices-constructor', 'bid-gte-error-value', 'Ставка не может быть больше {value}', { value: formattedValue }),
                search: iget2('b-prices-constructor', 'bid-search-gte-error-value', 'Ставка на поиске не может быть больше {value}', { value: formattedValue }),
                context: iget2('b-prices-constructor', 'bid-context-gte-error-value', 'Ставка в сетях не может быть больше {value}', { value: formattedValue })
            })[platform]
        };
    },

    getMinPercRule: function(platform) {
        var min = 0;

        return {
            value: min,
            text: (platform === 'search' ?
                iget2('b-prices-constructor', 'procenty-na-poiske-ne', 'Проценты на поиске не могут быть меньше') :
                iget2('b-prices-constructor', 'procenty-v-setyah-ne', 'Проценты в сетях не могут быть меньше ')) + ' ' + min + '%'
        };
    },

    getMaxPercRule: function(platform) {
        var max = 1000;

        return {
            value: max,
            text: (platform === 'search' ?
                iget2('b-prices-constructor', 'procenty-na-poiske-ne-110', 'Проценты на поиске не могут быть больше') :
                iget2('b-prices-constructor', 'procenty-v-setyah-ne-111', 'Проценты в сетях не могут быть больше')) + ' ' + max + '%'
        };
    }
});
