block('b-private-deals-camps-chooser')(

    js()(true),

    content()(function() {
        var ctx = this.ctx,
            campaigns = this.ctx.campaigns,
            campaignsByClient = u._.groupBy(campaigns, 'userName'),
            employedClients = Object.keys(campaignsByClient).sort();

        return [
            {
                block: 'pd-client-camps-chooser',
                mods: { initial: 'yes' },
                dealId: ctx.dealId,
                employedClients: employedClients,
                client: '',
                campaigns: []
            }
        ].concat(
            employedClients.map(function(client) {
                var campaigns = campaignsByClient[client];

                return {
                    block: 'pd-client-camps-chooser',
                    mix: {
                        block: 'b-private-deals-camps-chooser',
                        elem: 'client-choosed-control',
                        elemMods: { client: client }
                    },
                    dealId: ctx.dealId,
                    client: client,
                    campaigns: campaigns
                }
            })
        )
    })

);
