BEM.DOM.decl('b-private-deals-camps-chooser', {

    /**
     * Устанавливает state
     * @param {{[string]:boolean}} state
     */
    setState: function(state) {
        this.findBlocksInside('client-choosed-control', 'pd-client-camps-chooser').forEach(function(pdCampsChooser) {
            var client = this.getMod(pdCampsChooser.domElem, 'client');

            pdCampsChooser
                .blockInside('b-text-panel')
                .setMod('folded', state[client] ? 'no' : 'yes');
        }, this);
    },

    /**
     * Флаг о наличии изменений
     * @returns {boolean}
     */
    isChanged: function() {
        return this._getCampsChoosers().some(function(chooserClient) {
            return chooserClient.isChanged();
        })
    },

    /** Флаг о наличии реакции на ESC
     * @returns {boolean}
     */
    haveReactionToEsc: function() {
        return this._getCampsChoosers().some(function(block) {
            return block.haveReactionToEsc();
        });
    },

    /**
     * Возвращает значение
     * @returns {{toAdd: string[], toRemove: string[], addedCampaignsInfo: object}}
     */
    getValue: function() {
        var toAdd = [],
            toRemove = [],
            addedCampaignsInfo = {};

        this.findBlocksInside('pd-client-camps-chooser').forEach(function(chooserClient) {
            var chooserClientValue = chooserClient.getValue();

            toAdd = toAdd.concat(chooserClientValue.toAdd);
            toRemove = toRemove.concat(chooserClientValue.toRemove);
            addedCampaignsInfo = u._.extend(addedCampaignsInfo, chooserClientValue.addedCampaignsInfo);
        });

        return {
            toAdd: toAdd,
            toRemove: toRemove,
            addedCampaignsInfo: addedCampaignsInfo
        }
    },

    /**
     * Обработчик изменения контролов выбора кампаний
     * @param {jQuery.Event} e
     * @param {object} data
     * @param {boolean} data.isChanged
     * @private
     */
    _onChooserClientChange: function(e, data) {
        this.trigger('change', {
            isChanged: data.isChanged || this.isChanged()
        });
    },

    /**
     * Возвращает все контролы выбора клиентов/кампаний
     * @returns {BEM.DOM[]}
     * @private
     */
    _getCampsChoosers: function() {
        return this._campsChoosers || (this._campsChoosers = this.findBlocksInside('pd-client-camps-chooser'));
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('change', 'pd-client-camps-chooser', function(e, data) {
                this._onChooserClientChange(e, data);
            });
    }

});
