block('b-private-deals-inspector-unit').elem('actions')(
    content()(function() {
        var status = u._.get(this.data, 'deal.status');

        return [
            {
                block: 'b-error-pretty-message',
                js: true,
                mods: { theme: 'red', 'has-clear': 'yes' },
                mix: {
                    block: 'b-private-deals-inspector-unit',
                    elem: 'errors',
                    elemMods: { pos: 'buttons' }
                },
                attrs: { 'data-err-path': '' }
            },
            (status === 'ACTIVE' || status === 'COMPLETED' || status === 'ARCHIVED') && {
                block: 'button2',
                mods: { theme: 'action', size: 'm', disabled: 'yes', view: 'default', tone: 'default' },
                mix: {
                    block: 'b-private-deals-inspector-unit',
                    elem: 'action',
                    elemMods: { type: 'save' }
                },
                text: iget2('b-private-deals-inspector-unit', 'save-changes', 'Сохранить изменения')
            },
            status === 'RECEIVED' && {
                block: 'button2',
                mods: { theme: 'action', size: 'm', view: 'default', tone: 'default' },
                mix: {
                    block: 'b-private-deals-inspector-unit',
                    elem: 'action',
                    elemMods: { type: 'accept' }
                },
                text: iget2('b-private-deals-inspector-unit', 'accept-deal', 'Принять сделку')
            },
            (status === 'RECEIVED' || status === 'ACTIVE') && {
                block: 'button2',
                mods: { theme: 'pseudo', size: 'm', view: 'default', tone: 'default' },
                mix: {
                    block: 'b-private-deals-inspector-unit',
                    elem: 'action',
                    elemMods: { type: 'reject' }
                },
                text: iget2('b-private-deals-inspector-unit', 'reject-deal', 'Отклонить сделку')
            }
        ];
    })
);
