block('b-private-deals-inspector-unit').elem('deal-card')(

    match(function() { return !this.data.deal }).def()(''),

    mix()(function() {
        return [
            { block: 'b-text-panel', js: true },
            { elemMods: u._.pick(this.data.deal, ['id']) }
        ]
    }),

    content()(function() {
        var deal = this.data.deal,
            // DIRECT-80502: нужны площадки только с доменом
            placements = (deal.placements || []).filter(function(placement) {
                return placement.domain;
            });

        return [
            {
                block: 'b-text-panel',
                elem: 'head',
                content: [
                    {
                        block: 'b-private-deals-inspector-unit',
                        elem: 'stat',
                        content: [
                            {
                                elem: 'stat-item',
                                value: {
                                    block: 'b-private-deals-value',
                                    mods: { type: 'price' },
                                    mix: { block: 'b-text-panel', elem: 'on-top' },
                                    value: deal.min_price,
                                    currency: deal.currency_code
                                },
                                desc: iget2('b-private-deals-inspector-unit', 'min-bid-for-1000-shows', 'мин.&nbsp;ставка тыс.&nbsp;показов')
                            },
                            !!+deal.agency_fee_percent && {
                                elem: 'stat-item',
                                value: {
                                    block: 'b-private-deals-value',
                                    mods: { type: 'percentage' },
                                    mix: { block: 'b-text-panel', elem: 'on-top' },
                                    value: deal.agency_fee_percent
                                },
                                desc: iget2('b-private-deals-inspector-unit', 'premia', 'премия')
                            },
                            !!+deal.expected_impressions_per_week && {
                                elem: 'stat-item',
                                value: {
                                    block: 'b-private-deals-value',
                                    mix: { block: 'b-text-panel', elem: 'on-top' },
                                    value: deal.expected_impressions_per_week
                                },
                                desc: iget2('b-private-deals-inspector-unit', 'trafic_per_week', 'трафик в неделю')
                            }
                        ]
                    }
                ]
            },
            {
                block: 'b-text-panel',
                elem: 'content',
                content: [
                    {
                        block: 'b-private-deals-inspector-unit',
                        elem: 'info',
                        content: [
                            { elem: 'info-tooltip' },
                            {
                                elem: 'info-item',
                                title: iget2('b-private-deals-inspector-unit', 'deal-nubmer', 'Номер сделки'),
                                content: deal.id
                            },
                            !!deal.expected_money_per_week && {
                                elem: 'info-item',
                                title: iget2('b-private-deals-inspector-unit', 'money_per_week', 'Бюджет'),
                                content: [
                                    {
                                        block: 'b-private-deals-value',
                                        mods: { type: 'price' },
                                        value: +deal.expected_money_per_week,
                                        currency: deal.currency_code
                                    },
                                    '&nbsp;',
                                    iget2('b-private-deals-inspector-unit', 'per-week', 'в неделю')
                                ]
                            },
                            deal.description && {
                                elem: 'info-item',
                                title: iget2('b-private-deals-inspector-unit', 'description', 'Описание'),
                                content: deal.description
                            },
                            (deal.date_start && deal.date_end) && {
                                elem: 'info-item',
                                title: iget2('b-private-deals-inspector-unit', 'execution_time', 'Время проведения'),
                                content: [
                                    // От сервера получаем UTC и приводим к МСК (utc+3)
                                    u.moment(deal.date_start).add(3, 'hour').format(iget2('b-private-deals-inspector-unit', 'from-hh-mm-dd-mm-yyyy', 'с HH:mm DD.MM.YYYY')),
                                    '&nbsp;',
                                    u.moment(deal.date_end).add(3, 'hour').format(iget2('b-private-deals-inspector-unit', 'to-hh-mm-dd-mm-yyyy', 'по HH:mm DD.MM.YYYY'))
                                ]
                            },
                            !!deal.publisher_name && {
                                elem: 'info-item',
                                title: iget2('b-private-deals-inspector-unit', 'publisher-name', 'Название компании'),
                                content: deal.publisher_name
                            },
                            !!deal.contacts && {
                                elem: 'info-item',
                                title: iget2('b-private-deals-inspector-unit', 'contacts', 'Контакты'),
                                content: deal.contacts
                            },
                            {
                                elem: 'info-item',
                                elemMods: { level: 'top' },
                                title: iget2('b-private-deals-inspector-unit', 'placements', 'Площадки'),
                                content: placements.length ?
                                    placements.map(function(placement) {
                                        return {
                                            elem: 'info-item',
                                            title: placement.domain,
                                            content: (placement.formats || []).join(', ')
                                        };
                                    }) :
                                    {
                                        elem: 'info-item',
                                        content: iget2('b-private-deals-inspector-unit', 'net-zadannih-ploshadok', 'Нет заданных площадок')
                                    }
                            },
                            deal.targetings_text && {
                                elem: 'info-item',
                                elemMods: { level: 'top' },
                                title: iget2('b-private-deals-inspector-unit', 'targetings_text', 'Таргетинг'),
                                content: {
                                    elem: 'targeting',
                                    value: deal.targetings_text
                                }
                            }
                        ]
                    }
                ]
            }
        ];
    }),

    elem('info-item')(
        content()(function() {
            return [{ elem: 'info-item-title', content: this.ctx.title }]
                .concat(this.ctx.content);
        }),

        elemMod('level', 'top').content()(function() {
            return [{ elem: 'info-item-title', content: this.ctx.title, mix: { elem: 'group-title-text' } }]
                .concat(this.ctx.content);
        })
    ),

    elem('stat-item')(
        content()(function() {
            return [
                {
                    elem: 'black-text',
                    content: this.ctx.value
                },
                {
                    elem: 'gray-text',
                    content: this.ctx.desc
                }
            ];
        })
    ),

    elem('targeting')(
        def()(function() {
            var value = this.ctx.value;

            try {
                return applyCtx(
                    JSON.parse(value).map(function(targetingItem) {
                        return {
                            elem: 'info-item',
                            title: targetingItem.name,
                            content: targetingItem.value
                        };
                    })
                );
            } catch (e) {
                return applyCtx({
                    elem: 'info-item',
                    content: value
                });
            }
        })
    ),

    elem('info-tooltip')(
        def()(function() {
            return applyCtx({
                block: 'icon',
                mods: { 'size-12': 'info' },
                mix: [
                    {
                        block: 'b-hintable',
                        js: {
                            hint: iget2(
                                'b-private-deals-inspector-unit',
                                'yslovia-zadanu-adfox-esli-ne-podhodiat-otklonite',
                                'Условия размещения заданы площадкой в ADFOX, их нельзя изменить. Если условия не подходят, отклоните сделку.')
                        }
                    },
                    {
                        block: 'b-private-deals-inspector-unit',
                        elem: 'info-tooltip'
                    }
                ]
            });
        })
    )

);
