BEM.DOM.decl('b-private-deals-inspector-unit', {

    onSetMod: {
        js: function() {
            this._state = {};
        }
    },

    setState: function(state) {
        this._state || (this._state = {});

        if (!u._.isEqual(this._state, state)) {
            this.blockInside('title', 'b-private-deals-title').setState(
                u._.pick(state, ['isTitleEditing', 'editedTitle'])
            );

            if (!u._.isEqual(this._state.deals, state.deals)) {
                //cyn@ Понадобится при возможности выбора больше одной сделки
                // this.setMod(this.elem('group', 'content', 'deals'), 'hidden', state.deals ? '' : 'yes');

                if (state.deals) {
                    this.elem('deal-card').each(function(i, el) {
                        var dealCard = $(el),
                            id = this.getMod(dealCard, 'id');

                        this.blockInside(dealCard, 'b-text-panel').setMod('folded', state.deals[id] ? 'no' : 'yes');
                    }.bind(this));
                }
            }

            if (!u._.isEqual(this._state.clients, state.clients)) {
                this.setMod(this.elem('group', 'content', 'clients'), 'hidden', state.clients ? '' : 'yes');

                if (state.clients && this.blockInside('b-private-deals-camps-chooser')) {
                    this.blockInside('b-private-deals-camps-chooser').setState(state.clients);
                }
            }

            this._state = state;
        }

        return this;
    },

    getState: function() {
        return this._state
    },

    /**
     * Отображает ошибки
     * @param {{description: String, path: String}[]} errors
     */
    showErrors: function(errors) {
        var errorsPresenter = this.findBlockOn('b-errors-presenter2'),
            errorViewBlocks = errorsPresenter.showErrors(errors),
            groupSelector = this.buildSelector('group'),
            errorViewsInGroup = errorViewBlocks
                .map(function(err) { return err.domElem })
                .filter(function(errDomElem) {
                    return this.elem('errors', 'pos', 'group').is(errDomElem);
                }, this),
            groupsWithErrors = errorViewsInGroup
                .map(function(errDomElem) { return errDomElem.parents(groupSelector) }),
            someErrorViewIsVisible = errorViewsInGroup.some(this.isElemVisible, this);

        // Раскрываем группы с ошибками
        groupsWithErrors.forEach(function(group) {
            var groupName = this.getMod(group, 'content');

            if (!this._state[groupName]) {
                this._toggleVisibilityGroup(groupName);
            }
        }, this);

        if (errorViewsInGroup.length && !someErrorViewIsVisible) {
            this.scrollToElem(groupsWithErrors[0]);
        }
    },

    /**
     * Попадает ли элемент во вьюпорт
     * @param {jQuery} elem
     * @returns {Boolean}
     */
    isElemVisible: function(elem) {
        var elemBB = this._getElemBoundingBox(elem),
            wrapBB = this._getElemBoundingBox('wrap');

        return elemBB.top <= (wrapBB.height + wrapBB.top) && elemBB.bottom <= (wrapBB.height + wrapBB.bottom);
    },

    /**
     * Возвращает координаты элемента относительно окна
     * @param {String|jQuery} elem
     * @returns {ClientRect}
     * @private
     */
    _getElemBoundingBox: function(elem) {
        if (typeof elem === 'string') {
            elem = this.elem(elem);
        }

        return elem.get(0).getBoundingClientRect();
    },

    scrollToElem: function(elem) {
        this.blockInside('b-overflow-luxury-scroll').scrollTo(elem.position().top)
    },

    isChanged: function() {
        var canBeChangedBlocks = [
            this.blockInside('b-private-deals-camps-chooser'),
            this.blockInside('title', 'b-private-deals-title')
        ];

        return canBeChangedBlocks.some(function(block) {
            return block ? block.isChanged() : false
        });
    },

    _getValue: function() {
        var campsChooser = this.blockInside('b-private-deals-camps-chooser'),
            campsChooserValue = campsChooser && campsChooser.getValue(),
            titleEdit = this.blockInside('title', 'b-private-deals-title'),
            titleEditValue = titleEdit && titleEdit.getValue();

        return u._.assign(
            u._.pick(titleEditValue, ['name']),
            u._.pick(campsChooserValue, ['toAdd', 'toRemove', 'addedCampaignsInfo'])
        );
    },

    _updateStatusDeal: function(status) {
        this.trigger(
            'update-status',
            {
                status: status,
                isChanged: this.isChanged(),
                value: this._getValue()
            }
        );
    },

    _save: function() {
        if (this.isChanged()) {
            this.trigger('save', {
                value: this._getValue()
            });
        }
    },

    _cancel: function() {
        var campsChooser = this.blockInside('b-private-deals-camps-chooser');

        if (campsChooser) {
            this.trigger('cancel');
        }
    },

    _onButtonClick: function(e, data) {
        var domElem = e.block.domElem;

        if (this.elem('action').is(domElem)) {
            var actionName = this.getMod(domElem, 'type');

            this._clearErrors();

            switch (actionName) {
                case 'save': return this._save();
                case 'accept': return this._updateStatusDeal('accept');
                case 'reject': return this._updateStatusDeal('reject');
            }
        }
    },

    /**
     * Скрывает ошибки которые подходят по переданному `path`
     * @param {String} [path]
     */
    _clearErrors: function(path) {
        var errorsPresenter = this.findBlockOn('b-errors-presenter2');

        if (errorsPresenter) {
            errorsPresenter.clearErrors(path);
        }
    },

    _onCampsChooserChange: function(e, data) {
        this._toggleActiveActions(data.isChanged || this.isChanged())
    },

    _onTitleChange: function(e, data) {
        this.setState(
            u._.assign(
                {},
                this._state,
                { editedTitle: data.text }
            )
        );

        this._toggleActiveActions(data.isChanged || this.isChanged());
    },

    _toggleActiveActions: function(hasChanges) {
        ['save', 'cancel'].forEach(function(actionName) {
            var button = this.findBlockOn(this.elem('action', 'type', actionName), 'button2');

            button && button.toggleMod('disabled', '', 'yes', hasChanges);
        }.bind(this));
    },

    _onGroupTitleClick: function(e) {
        this._toggleVisibilityGroup(
            this.getMod(e.data.domElem.parent(this.buildSelector('group')), 'content')
        );
    },

    _toggleVisibilityGroup: function(groupName) {
        this.setState(
            u._.set(
                u._.assign({}, this._state),
                groupName,
                !u._.get(this._state, groupName)
            )
        );
    },

    _toggleMinimizeDealCard: function(e, data) {
        this._toggleStateItemVisible('deals', this.getMod(e.block.domElem, 'id'), data.value);
    },

    _onPdClientChooserToggleEditMode: function(e, data) {
        this._toggleStateItemVisible(data.stateKey, data.id, data.isFolded);
    },

    _toggleStateItemVisible: function(stateKey, id, isFolded) {
        var statePart = u._.assign({}, this._state[stateKey]);

        statePart[id] = !isFolded;

        this.setState(
            u._.assign(
                {},
                this._state,
                u._.set(
                    {},
                    stateKey,
                    statePart
                )
            )
        );
    },

    /**
     * Обработчик события ``
     * @param {jQuery.Event} e
     * @param {object} data
     * @param {string} [data.editedTitle] редактируемый заголовок
     * @private
     */
    _onTitleEditModeChange: function(e, data) {
        var updatedPartState = u._.pick(data, ['editedTitle']);

        updatedPartState.isTitleEditing = !u._.get(this._state, 'isTitleEditing');

        if (!updatedPartState.isTitleEditing) {
            this._clearErrors('deals');
        }

        this.setState(u._.assign({}, this._state, updatedPartState));
    },

    /**
     * Флаг о наличии реакции на нажатие ESC
     * @returns {boolean}
     */
    haveReactionToEsc: function() {
        var canHaveReactionToEscBlocks = [
            this.blockInside('title', 'b-private-deals-title'),
            this.blockInside('b-private-deals-camps-chooser')
        ];

        return canHaveReactionToEscBlocks.some(function(block) {
            return block ? block.haveReactionToEsc() : false;
        });
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('click', 'button2', function(e, data) {
                this._onButtonClick(e, data);
            })
            .liveInitOnBlockInsideEvent('folded', 'b-text-panel', function(e, data) {
                if (e.block.domElem.is(this.elem('deal-card'))) {
                    this._toggleMinimizeDealCard(e, data);
                }
            })
            .liveInitOnBlockInsideEvent('change', 'b-private-deals-camps-chooser', function(e, data) {
                this._onCampsChooserChange(e, data);
            })
            .liveInitOnBlockInsideEvent('edit-mode-change', 'pd-client-camps-chooser', function(e, data) {
                this._onPdClientChooserToggleEditMode(e, data);
            })
            .liveBindTo('group-title', 'pointerclick', function(e, data) {
                this._onGroupTitleClick(e, data);
            })
            .liveInitOnBlockInsideEvent('change', 'b-private-deals-title', function(e, data) {
                this._onTitleChange(e, data)
            })
            .liveInitOnBlockInsideEvent('change-edit-mode', 'b-private-deals-title', function(e, data) {
                this._onTitleEditModeChange(e, data);
            });
    }

});
