(function() {
    var errorsMapper,
        statusErrorsMapper;

    u.register({
        'b-private-deals-inspector': {

            getErrorsMapper: function() {
                return errorsMapper || (errorsMapper = u['b-private-deals-inspector'].createErrorsMapper());
            },

            createErrorsMapper: function() {
                return u['web-api-errors'].makeErrorMapper(
                    function(opts) {
                        var idx = opts.idx;

                        return [
                            {
                                path: ['add_links', idx, 'campaign_id'],
                                codes: [
                                    {
                                        code: 'DefectIds.OBJECT_NOT_FOUND',
                                        message: function(requestParams, err) {
                                            return iget2(
                                                'b-private-deals-inspector',
                                                'added-campaign-not-found2',
                                                'Не удалось привязать кампанию {cid}: кампания не&nbsp;найдена.',
                                                { cid: err.params.cid }
                                            );
                                        }
                                    },
                                    {
                                        code: 'CampaignDefectIds.Gen.CAMPAIGN_TYPE_NOT_SUPPORTED',
                                        message: function(requestParams, err) {
                                            return iget2(
                                                'b-private-deals-inspector',
                                                'added-campaign-type-is-not-supported3',
                                                'Не удалось привязать кампанию {cid}. Можно привязать только кампанию типа «Медийная кампания со сделками».',
                                                {
                                                    cid: function(params) {
                                                        return {
                                                            block: 'link',
                                                            target: '_blank',
                                                            url: u.getUrl('showCamp', {
                                                                cid: params.cid,
                                                                ulogin: params.ulogin
                                                            }),
                                                            content: params.cid
                                                        }
                                                    }(err.params || {})
                                                }
                                            );
                                        }
                                    },
                                    {
                                        code: 'CampaignDefectIds.Gen.ARCHIVED_CAMPAIGN_MODIFICATION',
                                        message: function(requestParams, err) {
                                            return iget2(
                                                'b-private-deals-inspector',
                                                'added-campaign-is-archived2',
                                                'Не удалось привязать кампанию {cid}: кампания находится в&nbsp;архиве.',
                                                {
                                                    cid: function(params) {
                                                        return {
                                                            block: 'link',
                                                            target: '_blank',
                                                            url: u.getUrl('showCamp', {
                                                                cid: params.cid,
                                                                ulogin: params.ulogin
                                                            }),
                                                            content: params.cid
                                                        }
                                                    }(err.params || {})
                                                }
                                            );
                                        }
                                    }
                                ]
                            },
                            {
                                path: ['add_links', idx, 'deal_id'],
                                codes: [
                                    {
                                        code: 'DealDefectIds.DEAL_IS_NOT_ACTIVE',
                                        message: function(requestParams, err) {
                                            return iget2(
                                                'b-private-deals-inspector',
                                                'add-to-not-active-deal3',
                                                'Не удалось привязать кампанию {cid}. Сделка должна быть со статусом «Принята».',
                                                {
                                                    cid: function(params) {
                                                        return {
                                                            block: 'link',
                                                            target: '_blank',
                                                            url: u.getUrl('showCamp', {
                                                                cid: params.cid,
                                                                ulogin: params.ulogin
                                                            }),
                                                            content: params.cid
                                                        };
                                                    }(err.params || {})
                                                }
                                            );
                                        }
                                    }
                                ]
                            },
                            {
                                path: ['add_links', idx],
                                codes: [
                                    {
                                        code: 'CampaingDealsDefectIds.MAX_NUMBER_OF_LINKED_DEALS_EXCEEDED',
                                        message: function(requestParams, err) {
                                            return iget2(
                                                'b-private-deals-inspector',
                                                'added-campaign-is-linked-already2',
                                                'Не удалось привязать кампанию {cid}: кампания уже привязана к сделке {currentDealId}',
                                                {
                                                    cid: function(params) {
                                                        return {
                                                            block: 'link',
                                                            target: '_blank',
                                                            url: u.getUrl('showCamp', {
                                                                cid: params.cid,
                                                                ulogin: params.ulogin
                                                            }),
                                                            content: params.cid
                                                        };
                                                    }(err.params || {}),
                                                    currentDealId: u._.get(err, 'params.linkedToDealIds[0]')
                                                }
                                            );
                                        }
                                    },
                                    {
                                        code: 'DealDefectIds.Currency.CAMPAIGN_AND_DEAL_CURRENCY_SHOULD_MATCH',
                                        message: function(requestParams, err) {
                                            return iget2(
                                                'b-private-deals-inspector',
                                                'currency-should-match-to-ru3',
                                                'Не удалось привязать кампанию {cid}: кампания в&nbsp;валюте «{currency}». Привязать можно только кампанию в&nbsp;рублях.',
                                                {
                                                    cid: function(params) {
                                                        return {
                                                            block: 'link',
                                                            target: '_blank',
                                                            url: u.getUrl('showCamp', {
                                                                cid: params.cid,
                                                                ulogin: params.ulogin
                                                            }),
                                                            content: params.cid
                                                        };
                                                    }(err.params || {}),
                                                    currency: u.currencies.getName(
                                                        err.params.currencyCode,
                                                        { full: true }
                                                    )
                                                }
                                            );
                                        }
                                    }
                                ]
                            },

                            {
                                path: ['remove_links', idx, 'campaign_id'],
                                codes: [
                                    {
                                        code: 'DefectIds.OBJECT_NOT_FOUND',
                                        message: function(requestParams, err) {
                                            return iget2(
                                                'b-private-deals-inspector',
                                                'removed-campaign-not-found2',
                                                'Не удалось отвязать кампанию {cid}: кампания не&nbsp;найдена.',
                                                { cid: err.params.cid }
                                            );
                                        }
                                    },
                                    {
                                        code: 'CampaignDefectIds.Gen.ARCHIVED_CAMPAIGN_MODIFICATION',
                                        message: function(requestParams, err) {
                                            return iget2(
                                                'b-private-deals-inspector',
                                                'removed-campaign-is-archived2',
                                                'Не удалось отвязать кампанию {cid}: кампания находится в&nbsp;архиве.',
                                                {
                                                    cid: function(params) {
                                                        return {
                                                            block: 'link',
                                                            target: '_blank',
                                                            url: u.getUrl('showCamp', {
                                                                cid: params.cid,
                                                                ulogin: params.ulogin
                                                            }),
                                                            content: params.cid
                                                        };
                                                    }(err.params || {})
                                                }
                                            );
                                        }
                                    },
                                    {
                                        code: 'CampaignDefectIds.Gen.CANT_REMOVE_DEALS_FROM_ACTIVE_CAMPAIGN',
                                        message: function(requestParams, err) {
                                            return iget2(
                                                'b-private-deals-inspector',
                                                'removed-campaign-is-active2',
                                                'Не удалось отвязать кампанию {cid}. Отвязать можно только кампанию со статусом «Черновик».',
                                                {
                                                    cid: function(params) {
                                                        return {
                                                            block: 'link',
                                                            target: '_blank',
                                                            url: u.getUrl('showCamp', {
                                                                cid: params.cid,
                                                                ulogin: params.ulogin
                                                            }),
                                                            content: params.cid
                                                        };
                                                    }(err.params || {})
                                                }
                                            );
                                        }
                                    }
                                ]
                            },
                            {
                                path: ['remove_links', idx, 'deal_id'],
                                codes: [
                                    {
                                        code: 'DealDefectIds.DEAL_IS_NOT_ACTIVE',
                                        message: function(requestParams, err) {
                                            return iget2(
                                                'b-private-deals-inspector',
                                                'remove-from-not-active-deal3',
                                                'Не удалось отвязать кампанию {cid}. Сделка должна быть со статусом «Принята».',
                                                {
                                                    cid: function(params) {
                                                        return {
                                                            block: 'link',
                                                            target: '_blank',
                                                            url: u.getUrl('showCamp', {
                                                                cid: params.cid,
                                                                ulogin: params.ulogin
                                                            }),
                                                            content: params.cid
                                                        };
                                                    }(err.params || {})
                                                }
                                            );
                                        }
                                    }
                                ]
                            },

                            {
                                path: ['deals', idx, 'name'],
                                codes: [
                                    {
                                        code: 'DefectIds.INVALID_VALUE',
                                        message: function() {
                                            return iget2(
                                                'b-private-deals-inspector',
                                                'invalid-symbols-at-name',
                                                'Значение в поле "название сделки" содержит спецсимволы'
                                            );
                                        }
                                    },
                                    {
                                        code: 'StringDefectIds.CANNOT_CONTAIN_SYMBOLS',
                                        message: function() {
                                            return iget2(
                                                'b-private-deals-inspector',
                                                'invalid-symbols-at-name',
                                                'Значение в поле "название сделки" содержит спецсимволы'
                                            );
                                        }
                                    },
                                    {
                                        code: 'StringDefectIds.CANNOT_BE_EMPTY',
                                        message: function() {
                                            return iget2(
                                                'b-private-deals-inspector',
                                                'name-cannot-be-empty',
                                                'Значение поля "название сделки" не может быть пустым'
                                            );
                                        }
                                    },
                                    u['web-api-errors'].commonCodes['StringDefectIds.MUST_CONTAIN_ONLY_SYMBOLS']({
                                        fieldName: iget2('b-private-deals-inspector', 'deal-name', 'название сделки')
                                    }),
                                    u['web-api-errors'].commonCodes['StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX']({
                                        fieldName: iget2('b-private-deals-inspector', 'deal-name', 'название сделки')
                                    })
                                ]
                            }
                        ];
                    },
                    function(obj, err) {
                        return err.message || iget2(
                            'b-private-deals-inspector',
                            'cant-save-changes3',
                            'При сохранении изменений произошла ошибка. Пожалуйста, попробуйте позже.'
                        );
                    }
                );
            },

            getStatusErrorsMapper: function() {
                return statusErrorsMapper || (statusErrorsMapper = u['b-private-deals-inspector'].createStatusErrorsMapper());
            },

            createStatusErrorsMapper: function() {
                return u['web-api-errors'].makeErrorMapper(
                    function(opts) {
                        var idx = opts.idx;

                        return [
                            {
                                path: [idx],
                                codes: [
                                    {
                                        code: 'DefectIds.OBJECT_NOT_FOUND',
                                        message: function(obj, err) {
                                            return iget2(
                                                'b-private-deals-inspector',
                                                'cant-change-status',
                                                'Не удалось изменить статус сделки "{id}"',
                                                { id: err.value }
                                            );
                                        }
                                    },
                                    {
                                        code: 'DealDefectIds.TRANSITION_IS_UNAVAILABLE',
                                        message: function() {
                                            return iget2(
                                                'b-private-deals-inspector',
                                                'ne-udalos-izmenit-status-obnovite-stranicu',
                                                'Не удалось изменить статус сделки. Пожалуйста, обновите страницу'
                                            );
                                        }
                                    }
                                ]
                            }
                        ]
                    },
                    function(obj, err) {
                        return err.message ||
                            iget2(
                                'b-private-deals-inspector',
                                'cant-save-changes2',
                                'Не удалось изменить статус сделки. Пожалуйста, обновите страницу.'
                            );
                    }
                );
            }
        }
    });
})();
