block('b-private-deals-table')(
    elem('data-cell')(

        tag()('td'),

        content()(function() {
            return this.ctx.data[this.ctx.field] || {
                block: 'b-private-deals-table',
                elem: 'empty'
            };
        }),

        elemMod('content-type', 'deal-type').content()(function() {
            var type = u.beminize(this.ctx.data[this.ctx.field]);

            return {
                elem: 'deal-type-icon',
                attrs: {
                    title: {
                        'preferred-deal': iget2('b-private-deals-table', 'chastnaja-sdelka', 'Частная сделка'),
                        'private-marketplace': iget2('b-private-deals-table', 'privat-aukcion', 'Приватный аукцион')
                    }[type]
                },
                elemMods: {
                    type: type
                }
            };
        }),

        elemMod('content-type', 'name').content()(function() {
            return [
                {
                    elem: 'data-cell-name',
                    js: { id: this.ctx.data.id },
                    content: [
                        this.addToSearch(this.ctx.data.name),
                        '&nbsp;',
                        {
                            block: 'icon',
                            mods: { 'size-16': 'settings' },
                            mix: { block: 'b-private-deals-table', elem: 'gear' }
                        }
                    ]
                },
                { elem: 'excel-space' },
                {
                    elem: 'data-cell-gray',
                    content: [
                        {
                            elem: 'deal-id',
                            content: this.addToSearch(this.ctx.data.id)
                        },
                        ',&nbsp;',
                        this.ctx.data.number_of_linked_campaigns ?
                            {
                                elem: 'deal-campaigns',
                                content: this.addToSearch(iget2('b-private-deals-table', 'linked-camps-count', '{camps} кампания', {
                                    camps: this.ctx.data.number_of_linked_campaigns,
                                    count: this.ctx.data.number_of_linked_campaigns,
                                    some: '{camps} кампании',
                                    many: '{camps} кампаний',
                                    context: '1 кампания'
                                }))
                            } :
                            this.addToSearch(iget2('b-private-deals-table', 'no-linked-campaigns', 'нет привязанных кампаний'))
                    ]
                }
            ];
        }),

        elemMod('content-type', 'status').content()(function() {
            var ctxData = this.ctx.data,
                state = ctxData.status;

            return {
                elem: 'data-cell-status',
                elemMods: { state: u.beminize(state) },
                content: this.addToSearch(
                    {
                        RECEIVED: iget2('b-private-deals-table', 'received', 'Получена'),
                        ACTIVE: iget2('b-private-deals-table', 'active2', 'Принята'),
                        COMPLETED: ctxData.complete_reason ?
                            {
                                BY_CLIENT: iget2('b-private-deals-table', 'completed-by-client', 'Отклонена&nbsp;агентством'),
                                BY_PUBLISHER: iget2('b-private-deals-table', 'completed-by-publisher', 'Отменена&nbsp;площадкой'),
                                BY_DATE: iget2('b-private-deals-table', 'completed-by-date', 'Завершена&nbsp;по&nbsp;дате')
                            }[ctxData.complete_reason] :
                            '',
                        ARCHIVED: iget2('b-private-deals-table', 'archived2', 'Перенесена&nbsp;в&nbsp;архив')
                    }[state]
                )
            };
        }),

        elemMod('content-type', 'min-price').content()(function() {
            return typeof this.ctx.data.min_price === 'number' ?
                {
                    block: 'b-private-deals-value',
                    mods: { type: 'price' },
                    value: this.ctx.data.min_price,
                    currency: this.ctx.data.currency_code
                } :
                {
                    block: 'b-private-deals-table',
                    elem: 'empty'
                };
        }),

        elemMod('content-type', 'spent').content()(function() {
            return typeof this.ctx.data.spent === 'number' ?
                {
                    block: 'b-private-deals-value',
                    mods: { type: 'price' },
                    value: this.ctx.data.spent,
                    currency: this.ctx.data.currency_code
                } :
                {
                    block: 'b-private-deals-table',
                    elem: 'empty'
                };
        }),

        elemMod('content-type', 'cpm').content()(function() {
            return typeof this.ctx.data.cpm === 'number' ?
                {
                    block: 'b-private-deals-value',
                    mods: { type: 'price' },
                    value: this.ctx.data.cpm,
                    currency: this.ctx.data.currency_code
                } :
                {
                    block: 'b-private-deals-table',
                    elem: 'empty'
                };
        }),

        elemMod('content-type', 'cpc').content()(function() {
            return typeof this.ctx.data.cpc === 'number' ?
                {
                    block: 'b-private-deals-value',
                    mods: { type: 'price' },
                    value: this.ctx.data.cpc,
                    currency: this.ctx.data.currency_code
                } :
                {
                    block: 'b-private-deals-table',
                    elem: 'empty'
                };
        }),

        elemMod('content-type', 'ctr').content()(function() {
            return typeof this.ctx.data.ctr === 'number' ?
                {
                    block: 'b-private-deals-value',
                    mods: { type: 'percentage' },
                    value: this.ctx.data.ctr
                } :
                {
                    block: 'b-private-deals-table',
                    elem: 'empty'
                };
        }),

        elemMod('content-type', 'shows').content()(function() {
            return typeof this.ctx.data.shows === 'number' ?
                {
                    block: 'b-private-deals-value',
                    value: this.ctx.data.shows
                } :
                {
                    block: 'b-private-deals-table',
                    elem: 'empty'
                };
        }),

        elemMod('content-type', 'clicks').content()(function() {
            return typeof this.ctx.data.clicks === 'number' ?
                {
                    block: 'b-private-deals-value',
                    value: this.ctx.data.clicks
                } :
                {
                    block: 'b-private-deals-table',
                    elem: 'empty'
                };
        })
    ),

    elem('deal-id').tag()('span'),

    elem('excel-space')(
        tag()('span'),

        content()(' ') // неразрывный пробел
    ),

    elem('data-cell-gray').tag()('span'),

    elem('data-cell-name').tag()('span'),

    elem('data-cell-status').tag()('span'),

    elem('deal-campaigns').tag()('span'),

    elem('data-cell-gray').match(function() {
        return !this.ctx.content
    }).def()('')
);
