block('b-private-deals-table').elem('head')(

    tag()('table'),

    content()(function() {
        var titles = apply('titles'),
            additions = apply('additions');

        return {
            elem: 'head-row',
            tag: 'tr',
            content: this.columnsList.map(function(column) {
                var columnKey = column.key,
                    columnKeyBeminized = u.beminize(columnKey);

                return {
                    elem: 'head-cell',
                    tag: 'td',
                    elemMods: {
                        'content-type': columnKeyBeminized,
                        type: column.info ? 'info' : 'data'
                    },
                    content: {
                        elem: 'head-cell-content',
                        content: [
                            {
                                elem: 'head-sort',
                                js: { field: columnKey },
                                elemMods: { 'sort-field': columnKeyBeminized },
                                content: [
                                    titles[columnKey],
                                    {
                                        block: 'icon',
                                        mods: { type: 'arrow', size: 'xs', direction: 'bottom' }
                                    }
                                ]
                            },
                            additions[columnKey]
                        ]
                    }
                };
            })
        }
    }),

    mode('titles')(function() {
        return {
            deal_type: iget2('b-private-deals-table', 'type', 'Тип'),
            name: iget2('b-private-deals-table', 'name', 'Название'),
            status: iget2('b-private-deals-table', 'status', 'Статус'),
            spent: iget2('b-private-deals-table', 'costs', 'Расходы'),
            shows: iget2('b-private-deals-table', 'shows', 'Показы'),
            min_price: iget2('b-private-deals-table', 'min-bid-for-1000-shows', 'Мин. ставка тыс. показов'),
            cpm: iget2('b-private-deals-table', 'cpm', 'CPM'),
            clicks: iget2('b-private-deals-table', 'clicks_uppercase', 'Клики'),
            cpc: iget2('b-private-deals-table', 'cpc', 'CPC'),
            ctr: iget2('b-private-deals-table', 'ctr', 'CTR')
        };
    }),

    mode('additions')(function() {
        return {
            spent: {
                block: 'icon',
                mods: { 'size-12': 'info' },
                mix: [
                    {
                        block: 'b-hintable',
                        js: { hint: iget2('b-private-deals-table', 'without-nds', 'Без учёта НДС') }
                    },
                    {
                        block: 'b-private-deals-table',
                        elem: 'head-spent-icon'
                    }
                ]
            }
        };
    })
);
