block('b-private-deals-table')(
    replace()(function() {
        var searchIndex = [],
            html = applyNext({
                columnsList: [
                    { key: 'deal_type', info: true },
                    { key: 'name', info: true },
                    { key: 'status', info: true },
                    { key: 'spent' },
                    { key: 'shows' },
                    { key: 'min_price' },
                    { key: 'cpm' },
                    { key: 'clicks' },
                    { key: 'cpc' },
                    { key: 'ctr' }
                ],
                searchIndex: searchIndex
            });

        return {
            block: 'b-private-deals-table-search-index',
            js: { searchIndex: searchIndex },
            content: { html: html }
        };
    }),

    js()(function() {
        return {
            columnsList: this.columnsList
        }
    }),

    mix()(function() {
        return {
            block: 'b-metrika2',
            js: {
                blockName: 'b-private-deals-table',
                target: 'DEAL_CONDITIONS',
                event: 'deal-selected'
            }
        }
    }),

    content()(function() {
        return [
            { elem: 'filter' },
            { elem: 'head' },
            {
                elem: 'body',
                columnsList: this.columnsList,
                deals: this.ctx.deals,
                addToSearch: function(rowIndex, text) {
                    this.searchIndex[rowIndex] = (this.searchIndex[rowIndex] || '') + (text + '').toLowerCase() + '\n';

                    return {
                        block: this.block,
                        elem: 'hlt',
                        content: text
                    };
                }
            }
        ]
    }),

    elem('body-table').tag()('table'),

    elem('empty')(
        tag()('span'),

        content()(function() {
            return '&ndash;';
        })
    ),

    elem('hlt').tag()('span'),
    elem('hlted').tag()('span')
);
