BEM.DOM.decl('b-private-deals-title', {

    onSetMod: {

        js: function() {
            this._state = {};

            this._oldText = this.params.value;

            this.bindToDoc('keydown', this._onKeyDown);
        }

    },

    /**
     * Устанавливает state
     * @param {object} state
     * @param {boolean} state.isTitleEditing режим редактирования
     * @param {string} state.editedTitle редактируемое значение
     */
    setState: function(state) {
        if (this.hasMod('editing', 'disabled')) {
            return;
        }

        if (!u._.isEqual(this._state, state)) {
            if (state.isTitleEditing !== this._state.isTitleEditing) {
                this._updateContent(state.isTitleEditing, state.editedTitle);
            }

            if (state.isTitleEditing && state.editedTitle !== this._state.editedTitle) {
                this._setText(state.editedTitle);
            }

            this._state = state;
        }
    },

    /**
     * Обновляет контент блока: режим редактирования и значение
     * @param {boolean} isTitleEditing
     * @param {string} editedTitle
     * @private
     */
    _updateContent: function(isTitleEditing, editedTitle) {
        this.setMod('editing', isTitleEditing ? 'yes' : 'no');

        BEM.DOM.update(
            this.domElem,
            BEMHTML.apply({
                block: this.__self.getName(),
                mods: this.getMods(),
                elem: 'content',
                value: this._oldText
            })
        );

        this
            .dropElemCache('counter')
            .dropBlockInsideCache('textinput');

        if (isTitleEditing) {
            this._setText(editedTitle, true);
        }
    },

    /**
     * Флаг наличия изменений
     * @return {boolean}
     */
    isChanged: function() {
        return this._state.isTitleEditing ?
            this._state.editedTitle !== this._oldText :
            false;
    },

    /**
     * Возвращает значение
     * @return {{name: string}}
     */
    getValue: function() {
        return this._state.isTitleEditing ?
            { name: this._state.editedTitle } :
            {};
    },

    /**
     * Устанавливает значение
     * @param {string} text значение
     * @param {boolean} needSelect флаг необходимости выделения текста
     * @private
     */
    _setText: function(text, needSelect) {
        var countLeftSymbols = 255 - text.length;

        this.blockInside('textinput').setText(text);

        if (needSelect) {
            this.blockInside('textinput').selectText();
        }

        this.setMod(
            this.elem('counter').text(countLeftSymbols),
            'valid',
            countLeftSymbols >= 0 ? 'yes' : 'no'
        );
    },

    /**
     * Обработчик клика по блока с модификатором `_editing_no`
     * @private
     */
    _onContentClick: function() {
        this.trigger('change-edit-mode');
    },

    /**
     * Обратчик изменений инпута
     * @param {jQuery.Event} e
     * @private
     */
    _onInputChange: function(e, data) {
        var text = data.text;

        this.trigger('change', { isChanged: text !== this._oldText, text: text });
    },

    /**
     * Обратчик ухода фокуса с инпута
     * @param {jQuery.Event} e
     * @private
     */
    _onInputBlur: function(e) {
        if (!this.isChanged()) {
            this.afterCurrentEvent(function() {
                this.trigger('change-edit-mode');
            });
        }
    },

    /**
     * Флаг о наличии реакции на нажатие ESC
     * @return {Boolean}
     */
    haveReactionToEsc: function() {
        return this.hasMod('editing', 'yes') && this.blockInside('textinput').hasMod('focused', 'yes');
    },

    /**
     * Обработчик события `keydown`
     * @param {jQuery.Event} e
     * @private
     */
    _onKeyDown: function(e) {
        if (BEM.blocks.keycodes.is(e.keyCode, 'ESC') && this.haveReactionToEsc()) {
            this
                .trigger('change-edit-mode')
                .trigger('change', { isChanged: false, text: this._oldText });
        }
    }

}, {

    live: function() {
        this
            .liveBindTo({ modName: 'editing', modVal: 'no' }, 'pointerclick', function(e, data) {
                this._onContentClick(e, data);
            })
            .liveInitOnBlockInsideEvent('change', 'textinput', function(e, data) {
                this._onInputChange(e, data);
            })
            .liveInitOnBlockInsideEvent('blur', 'textinput', function(e, data) {
                this._onInputBlur(e, data);
            });
    }

});
